package tk.javacvs.swing.dialog;

import java.io.*;
import java.awt.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * ^O폜邽߂̃_CAOB
 */
public class RemoveTagDialog extends CVSDialog {
	
	private File[] files;
	private JCheckBox currentOnly;
	private HistoryComboBox tagName;
	
	public RemoveTagDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.remove_tag"));
		this.files = files;
	}

	/* ( Javadoc)
	 * @see tk.javacvs.swing.dialog.CVSDialog#createPanel()
	 */
	protected JPanel createPanel() {
		// R|[lg̏
		tagName     = new HistoryComboBox(new File("tag.history"));
		currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		
		// R|[lg̔zu
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BoxLayout(panel1,BoxLayout.X_AXIS));
		panel1.add(new JLabel(Util.getProperty("dialog.label.tag_name")));
		panel1.add(tagName);
		
		panel.add(panel1);
		panel.add(SwingUtil.createVerticalPanel(new JComponent[]{currentOnly}));
		
		return panel;
	}

	/* ( Javadoc)
	 * @see tk.javacvs.swing.dialog.CVSDialog#doProcess()
	 */
	protected void doProcess() throws Exception {
		TagInfo info = new TagInfo();
		info.setFiles(files);
		info.setTagName(tagName.getText());
		info.setCurrentOnly(currentOnly.isSelected());
		info.setRemove(true);
		
		CVS cvs = window.getCVS();
		cvs.tag(window.getRoot(),info);
		
		tagName.saveHistory();
	}

}
