package tk.javacvs.swing.dialog;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * Update̐ݒs_CAOB
 */
public class UpdateDialog extends CVSDialog {
	
	private JCheckBox       createDir;
	private JCheckBox       removeDir;
	private JCheckBox       removeSticky;
	private JCheckBox       updateLocal;
	private JCheckBox       currentOnly;
	private HistoryComboBox revision;
	private JCheckBox       selectDate;
	private JRadioButton    noMerge;
	private JRadioButton    mergeRev;
	private JRadioButton    mergeRevs;
	private HistoryComboBox mergeRevision1;
	private HistoryComboBox mergeRevision2;
	private JCheckBox       checkMerge;
	private File[]          files;
	
	/**
	 * RXgN^
	 *
	 * @param window MainWindow̃CX^X
	 * @param files  Ώۂ̃t@CQ
	 */
	public UpdateDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.update"));
		this.files  = files;
	}
	
	/**
	 * pl쐬܂B
	 */
	protected JPanel createPanel(){
		// R|[lg̏
		createDir        = new JCheckBox(Util.getProperty("dialog.label.upd_create_dir"));
		removeDir        = new JCheckBox(Util.getProperty("dialog.label.upd_del_empty"));
		removeSticky     = new JCheckBox(Util.getProperty("dialog.label.upd_del_sticky"));
		updateLocal      = new JCheckBox(Util.getProperty("dialog.label.upd_del_local"));
		currentOnly      = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		revision         = new HistoryComboBox(new File("tag.history"));
		selectDate       = new JCheckBox(Util.getProperty("dialog.label.select_date"));
		noMerge          = new JRadioButton(Util.getProperty("dialog.label.merge_none"));
		mergeRev         = new JRadioButton(Util.getProperty("dialog.label.merge_rev"));
		mergeRevs        = new JRadioButton(Util.getProperty("dialog.label.merge_revs"));
		mergeRevision1   = new HistoryComboBox(new File("tag.history"));
		mergeRevision2   = new HistoryComboBox(new File("tag.history"));
		checkMerge       = new JCheckBox(Util.getProperty("dialog.label.merge"));
		
		ButtonGroup group = new ButtonGroup();
		group.add(noMerge);
		group.add(mergeRev);
		group.add(mergeRevs);
		noMerge.setSelected(true);
		
		RadioActionListener radioListener = new RadioActionListener();
		noMerge.addActionListener(radioListener);
		mergeRev.addActionListener(radioListener);
		mergeRevs.addActionListener(radioListener);
		
		mergeRevision1.setEnabled(false);
		mergeRevision2.setEnabled(false);
		
		// XVpl쐬
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BoxLayout(panel1,BoxLayout.Y_AXIS));
		panel1.add(SwingUtil.createVerticalPanel(new JComponent[]{createDir,removeSticky,updateLocal,currentOnly,removeDir}));
		panel1.add(SwingUtil.createInputRevisionPanel(selectDate,revision));
		panel1.add(SwingUtil.createVerticalPanel(new JComponent[]{checkMerge}));
		
		// }[Wpl쐬iftHgł͔\j
		JPanel panel2 = new JPanel();
		panel2.setLayout(new BoxLayout(panel2,BoxLayout.Y_AXIS));
		panel2.add(SwingUtil.createVerticalPanel(new JComponent[]{noMerge,mergeRev,mergeRevs}));
		panel2.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.merge_text"),mergeRevision1));
		panel2.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.merge_text"),mergeRevision2));
		panel2.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.merge")));
		
		panel1.add(panel2);
		
		checkMerge.addActionListener(new MergeActionListener(panel2));
		panel2.setVisible(false);
		
		return panel1;
	}
	
	/**
	 * _CAO͓̓eUpdateInfo쐬ACVS#updateĂяo܂B
	 */
	protected void doProcess() throws Exception {
		
		UpdateInfo info = new UpdateInfo();
		info.setFiles(files);
		info.setRemoveEmpty(removeDir.isSelected());
		info.setRemoveSticky(removeSticky.isSelected());
		info.setCreateDir(createDir.isSelected());
		info.setCurrentOnly(currentOnly.isSelected());
		info.setUpdateLocal(updateLocal.isSelected());
		info.setRevision(revision.getText());
		info.setSelectDate(selectDate.isSelected());
		
		if(mergeRev.isSelected()){
			info.setMergeRevision1(mergeRevision1.getText());
			
		} else if(mergeRevs.isSelected()){
			info.setMergeRevision1(mergeRevision1.getText());
			info.setMergeRevision2(mergeRevision2.getText());
		}
		
		CVS cvs = window.getCVS();
		cvs.update(window.getRoot(),info);
		
		// ̕ۑ
		revision.saveHistory();
		mergeRevision1.saveHistory();
		mergeRevision2.saveHistory();
	}

	////////////////////////////////////////////////////////////////////////////
	// WI{^̃ANVXi
	////////////////////////////////////////////////////////////////////////////
	private class RadioActionListener implements ActionListener {
		public void actionPerformed(ActionEvent evt){
			Object obj = evt.getSource();
			if(obj==noMerge){
				mergeRevision1.setEnabled(false);
				mergeRevision2.setEnabled(false);
				
			} else if(obj==mergeRev){
				mergeRevision1.setEnabled(true);
				mergeRevision2.setEnabled(false);
				
			} else if(obj==mergeRevs){
				mergeRevision1.setEnabled(true);
				mergeRevision2.setEnabled(true);
				
			}
		}
	}

	////////////////////////////////////////////////////////////////////////////
	// }[WIvV`FbN{bNX̃ANVXi
	////////////////////////////////////////////////////////////////////////////
	private class MergeActionListener implements ActionListener {
		
		private JPanel mergePanel;
		
		public MergeActionListener(JPanel mergePanel){
			this.mergePanel = mergePanel;
		}
		
		public void actionPerformed(ActionEvent evt){
			this.mergePanel.setVisible(checkMerge.isSelected());
			pack();
		}
	}
}
