package tk.javacvs.swing.graph;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import tk.javacvs.*;

/**
 * Ot\pl
 */
public class Graph extends JPanel {
	
	private Revision[] revs;
	
	/**
	 * RXgN^
	 *
	 * @param log cvs̍XVO
	 */
	public Graph(String log){
		super();
		this.revs = getRevisions(log);
		this.setLayout(new GraphLayoutManager());
		for(int i=0;i<revs.length;i++){
			add(revs[i]);
		}
		this.doLayout();
	}
	
	/**
	 * rWplɃ}EXXiݒ肵܂B
	 */
	public void addRevisionMouseListener(MouseListener listener){
		for(int i=0;i<revs.length;i++){
			revs[i].addMouseListener(listener);
		}
	}
	
	/**
	 *
	 */
	public void paint(Graphics g){
		
		super.paint(g);
		
		// RevisionR|[lgԂɐ܂
		for(int i=0;i<revs.length;i++){
			Revision from = revs[i].getFrom();
			if(from!=null){
				int myRev   = Util.split(revs[i].getRevision(),".").length;
				int fromRev = Util.split(from.getRevision()   ,".").length;
				
				if(myRev==fromRev){
					Point     myLoc   = revs[i].getLocation();
					Dimension myDim   = revs[i].getPreferredSize();
					Point     fromLoc = from.getLocation();
					Dimension fromDim = from.getPreferredSize();
					
					int startX = (int)(fromLoc.getX() + (fromDim.getWidth()  / 2));
					int startY = (int)(fromLoc.getY() + fromDim.getHeight());
					int endX   = startX;
					int endY   = (int)myLoc.getY();
					g.drawLine(startX,startY,endX,endY);
					
				} else {
					Point     myLoc   = revs[i].getLocation();
					Dimension myDim   = revs[i].getPreferredSize();
					Point     fromLoc = from.getLocation();
					Dimension fromDim = from.getPreferredSize();
					
					int startX = (int)(myLoc.getX()   + (myDim.getWidth()    / 2));
					int startY = (int)(fromLoc.getY() + (fromDim.getHeight() / 2));
					int endX   = startX;
					int endY   = (int)myLoc.getY();
					g.drawLine(startX,startY,endX,endY);
					
					startX = (int)(fromLoc.getX() + fromDim.getWidth());
					endY   = startY;
					g.drawLine(startX,startY,endX,endY);
				}
			}
		}
		
	}
	
	////////////////////////////////////////////////////////////////////////////
	// CVS̍XVOp[X邽߂̃\bhQ
	////////////////////////////////////////////////////////////////////////////
	/**
	 * CVS̍XVORevisionR|[lg̔z쐬܂B
	 */
	private static Revision[] getRevisions(String log){
		
		// ܂O
		ArrayList list = parseLog(log);
		
		// gN
		ArrayList revs   = new ArrayList();
		ArrayList branch = new ArrayList();
		Revision  from   = null;
		for(int i=list.size()-1;i>=0;i--){
			HashMap hash = (HashMap)list.get(i);
			String   revision = (String)hash.get("Revision");
			String   comment  = (String)hash.get("Comment");
			String[] tags     = (String[])hash.get("Tag");
			String   user     = (String)hash.get("User");
			String   date     = (String)hash.get("Date");
			// u`̏ꍇ͕ۗ
			int splitLength = Util.split(revision,".").length;
			if(splitLength != 2){
				// rWԍẐɂ悤ɂ
				int insertIndex = 0;
				for(int j = 0;j<branch.size();j++){
					insertIndex++;
					HashMap map = (HashMap)branch.get(j);
					if(splitLength < Util.split((String)map.get("Revision"),".").length){
						insertIndex--;
						break;
					}
				}
				branch.add(insertIndex,hash);
				
			// gN̏ꍇ͒ǉ
			} else {
				Revision rev = new Revision(revision,tags,user,date,comment,from);
				revs.add(rev);
				from = rev;
			}
		}
		
		// u`
		ArrayList branchRevs = new ArrayList();
		for(int i=0;i<branch.size();i++){
			HashMap  hash     = (HashMap)branch.get(i);
			String   revision = (String)hash.get("Revision");
			String   comment  = (String)hash.get("Comment");
			String[] tags     = (String[])hash.get("Tag");
			String   user     = (String)hash.get("User");
			String   date     = (String)hash.get("Date");
			from = null;
			
			// h
			String searchRev  = revision;
			while(from==null){
				// u`̐擪̃rWiu`^ÔrWj
				// x.x.0.2 ̏ꍇ x.x 
				if(searchRev.indexOf(".0.")!=-1){
					searchRev = searchRev.substring(0,searchRev.lastIndexOf(".0."));
					
				// u`̍ŏ̃R~bgiu`^ÕrWj
				// Ⴆ x.x.2.1 ̏ꍇAx.x.0.2 
				} else if(searchRev.endsWith(".1")){
					searchRev = searchRev.substring(0,searchRev.lastIndexOf("."));
					String bNum = searchRev.substring(searchRev.lastIndexOf("."),searchRev.length());
					searchRev = searchRev.substring(0,searchRev.lastIndexOf("."));
					searchRev = searchRev + ".0" + bNum;
					
				// ̑̏ꍇ
				// x.x.x.x ̏ꍇ x.x.x 
				} else {
					searchRev = searchRev.substring(0,searchRev.lastIndexOf("."));
				}
				int loop = 0;
				// ŏ̈͏ς̃u`猟
				if(loop == 0){
					for(int j=0;j<branchRevs.size();j++){
						Revision revObj = (Revision)branchRevs.get(j);
						String branchRevision = revObj.getRevision();
						branchRevision = branchRevision.substring(0,branchRevision.lastIndexOf("."));
						if(branchRevision.equals(searchRev)){
							from = revObj;
							break;
						}
					}
				}
				// gN܂߂Č
				for(int j=0;j<revs.size();j++){
					Revision revObj = (Revision)revs.get(j);
					if(revObj.getRevision().equals(searchRev)){
						from = revObj;
						break;
					}
				}
				loop++;
			}
			Revision rev = new Revision(revision,tags,user,date,comment,from);
			revs.add(rev);
			branchRevs.add(rev);
		}
		// zɂĕԂ
		return (Revision[])revs.toArray(new Revision[revs.size()]);
	}
	
	
	/**
	 * CVSOp[X܂BRevisionR|[lgɕϊ邽߂̑OłB
	 */
	private static ArrayList parseLog(String log){
		
		ArrayList list = new ArrayList();
		String[] lines = Util.split(log,"\n");
		
		String revision = null;
		String user     = null;
		String date     = null;
		
		HashMap tagMap  = new HashMap();
		StringBuffer comment = new StringBuffer();
		int mode = 0;
		
		// O
		for(int i=0;i<lines.length;i++){
			// ^Ỏ
			if(mode==0 && lines[i].startsWith("\t")){
				String[] dim = null;
				if(lines[i].indexOf(":")!=-1){
					dim = Util.split(lines[i],":");
				} else {
					dim = Util.split(lines[i]," ");
				}
				
				String rev = null;
				String tag = null;
				
				if(dim[0].indexOf(".")!=-1){
					rev = Util.trim(dim[0]);
					tag = Util.trim(dim[1]);
				} else {
					rev = Util.trim(dim[1]);
					tag = Util.trim(dim[0]);
				}
				
				if(tagMap.get(rev)==null){
					ArrayList tagList = new ArrayList();
					tagList.add(tag);
					tagMap.put(rev,tagList);
					
				} else {
					ArrayList tagList = (ArrayList)tagMap.get(rev);
					tagList.add(tag);
				}
				
			// rWƂ̉͊Jn
			} else if(mode==0 && lines[i].startsWith("----------------------------")){
				mode = 1;
			
			// rW
			} else if(mode==1){
				revision = Util.trim(lines[i]);
				mode     = 2;
				comment.append(lines[i]+"\n");
				if(revision.indexOf(":")!=-1){
					revision = Util.trim(Util.split(revision,":")[1]);
				} else if(revision.indexOf(" ")!=-1){
					revision = Util.trim(Util.split(revision," ")[1]);
				}
				
			} else if(mode==2){
				mode = 3;
				if(lines[i].indexOf(";")!=-1){
					String[] dim = Util.split(lines[i],";");
					date = dim[0].substring(dim[0].indexOf(":")+1,dim[0].length());
					user = dim[1].substring(dim[1].indexOf(":")+1,dim[1].length());
				}
				comment.append(lines[i]+"\n");
				
			// rW̏I
			} else if(mode==3){
				if(lines[i].equals("----------------------------") ||
				   lines[i].startsWith("===============================================")){
					HashMap hash = new HashMap();
					hash.put("Revision",revision);
					hash.put("User",user);
					hash.put("Date",date);
					hash.put("Comment" ,comment.toString());
					
					if(tagMap.get(revision)==null){
						hash.put("Tag",new String[0]);
					} else {
						ArrayList tags = (ArrayList)tagMap.get(revision);
						hash.put("Tag",(String[])tags.toArray(new String[tags.size()]));
					}
					
					list.add(hash);
					
					comment = new StringBuffer();
					mode    = 1;
					
				} else {
					comment.append(lines[i]+"\n");
				}
			} 
		}
		
		// u`̊JnrWƂĒǉ
		Iterator ite = tagMap.keySet().iterator();
		while(ite.hasNext()){
			String key = (String)ite.next();
			if(key.indexOf(".0.")!=-1){
				HashMap hash = new HashMap();
				hash.put("Revision",key);
				hash.put("Comment" ,"");
				hash.put("User" ,"");
				hash.put("Date" ,"");
				ArrayList tags = (ArrayList)tagMap.get(key);
				hash.put("Tag",(String[])tags.toArray(new String[tags.size()]));
				list.add(hash);
			}
		}
		
		return list;
	}
	
	////////////////////////////////////////////////////////////////////////////
	// Ot̃CAEg}l[W
	////////////////////////////////////////////////////////////////////////////
	private class GraphLayoutManager implements LayoutManager {
		
		private int width  = 0;
		private int height = 0;
		
		public void addLayoutComponent(String s, Component c){
		}
		
		public void removeLayoutComponent(Component c){
		}
		
		public Dimension preferredLayoutSize(Container target) {
			return new Dimension(width,height);
		}
		
		public Dimension minimumLayoutSize(Container target) {
			return new Dimension(width,height);
		}
		
		public void layoutContainer(Container target) {
			
			int count  = target.getComponentCount();
			int width  = getMaxWidth(target);
			int branch = 0;
			
			// ʒuƃTCYݒ
			for (int i = 0; i < count; i++) {
				Revision  rev = (Revision)target.getComponent(i);
				Dimension dim = rev.getPreferredSize();
				dim.setSize(width,dim.getHeight());
				rev.setSize(dim);
				
				// [grW̏ꍇ
				if(rev.getFrom()==null){
					rev.setLocation(20,20);
					
				// [gȊȌꍇ
				} else {
					Revision from = rev.getFrom();
					String[] revNum  = Util.split(rev.getRevision() ,".");
					String[] fromNum = Util.split(from.getRevision(),".");
					// }̏ꍇ
					if(revNum.length==fromNum.length){
						Point     loc  = from.getLocation();
						Dimension size = from.getSize();
						rev.setLocation((int)(loc.getX()),
						                (int)(loc.getY() + size.getHeight() + 20));
						
					// Ⴄ}̏ꍇ
					} else {
						branch++;
						Point     loc  = from.getLocation();
						Dimension size = from.getSize();
						rev.setLocation((int)(20         + (branch * (width + 20))),
						                (int)(loc.getY() + size.getHeight() + 20));
					}
				}
				
				// CAEgTCY̍XV
				Point loc = rev.getLocation();
				int layoutWidth  = (int)(loc.getX() + dim.getWidth()  + 20);
				int layoutHeight = (int)(loc.getY() + dim.getHeight() + 20);
				if(this.width < layoutWidth){
					this.width = layoutWidth;
				}
				if(this.height < layoutHeight){
					this.height = layoutHeight;
				}
			}
		}
		
		/** rWR|[lg̍ő啝擾 */
		private int getMaxWidth(Container target){
			int count = target.getComponentCount();
			int width = 0;
			for (int i = 0; i < count; i++) {
				Component comp = target.getComponent(i);
				Dimension dim  = comp.getPreferredSize();
				if(width < dim.getWidth()){
					width = (int)dim.getWidth();
				}
			}
			return width;
		}
	}
}
