package tk.javacvs.swing.graph;

import java.io.*;
import java.awt.event.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * Ot\EBhE
 */
public class GraphWindow extends JFrame {
	
	private MainWindow window;
	private OutputView output;
	private Graph graph;
	private File file;
	
	/**
	 * RXgN^
	 */
	public GraphWindow(MainWindow window,Graph graph,File file){
		super();
		this.window = window;
		this.graph  = graph;
		this.file   = file;
		
		this.setTitle(Util.getProperty("menu.cvs.graph") + " - " + file.getName());
		
		this.output = new OutputView(window);
		JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		
		split.add(new JScrollPane(graph));
		split.add(new JScrollPane(output));
		split.setDividerLocation(280);
		
		graph.addRevisionMouseListener(new RevisionMouseListener());
		
		this.getContentPane().add(split);
		this.setSize(500,450);
		
		
		// _CAOEBhE̒ɕ\
		int x = (window.getWidth()  - this.getWidth())  / 2 + window.getX();
		int y = (window.getHeight() - this.getHeight()) / 2 + window.getY();
		this.setLocation(x,y);
	}
	
	
	///////////////////////////////////////////////////////////////////////////
	// }EXXi
	///////////////////////////////////////////////////////////////////////////
	private class RevisionMouseListener extends MouseAdapter {
		public void mouseClicked(MouseEvent evt){
			// NA
			output.setText("");
			// NbNꂽrW擾
			Revision rev = (Revision)evt.getSource();
			String log = rev.getLog();
			if(log.equals("")){
				return;
			}
			// Ps}
			String[] lines = Util.split(log,"\n");
			for(int i=0;i<lines.length;i++){
				output.insertString(lines[i]+"\n");
			}
		}
	}
}
