/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.io.ByteArrayInputStream;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import tk.eclipse.plugin.struts.StrutsConfigModel2XML;
import tk.eclipse.plugin.struts.StrutsConfigXML2Model;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.GraphicalStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.StrutsConfigOutlinePage;
import tk.eclipse.plugin.struts.editors.StrutsConfigXMLEditor;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class MultiPageStrutsConfigEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private GraphicalStrutsConfigEditor graphicalEditor;
    private StrutsConfigXMLEditor textEditor;
    private StrutsConfigOutlinePage outlinePage;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    boolean firstFlag = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MultiPageStrutsConfigEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.outlinePage = new StrutsConfigOutlinePage(this);
    }

    private void createPage0() {
        try {
            this.graphicalEditor = new GraphicalStrutsConfigEditor(this.outlinePage);
            int index = this.addPage((IEditorPart)this.graphicalEditor, this.getEditorInput());
            this.setPageText(index, this.resource.getString("editor.tab.flow"));
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage1() {
        try {
            this.textEditor = new StrutsConfigXMLEditor();
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, this.resource.getString("editor.tab.source"));
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor instanceof StrutsConfigXMLEditor) {
            return new SourceEditorSite(this, editor, this.getEditorSite());
        }
        return super.createSite(editor);
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.syncEditors(1);
    }

    public RootModel getRoot() {
        return this.graphicalEditor.getRoot();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.syncEditors(this.getActivePage());
        this.textEditor.doSave(monitor);
        this.graphicalEditor.doSave();
    }

    public void doSaveAs() {
        this.syncEditors(this.getActivePage());
        this.textEditor.doSaveAs();
        this.setInput(this.textEditor.getEditorInput());
        this.graphicalEditor.doSave(this.textEditor.getEditorInput());
        this.setPartName(this.textEditor.getEditorInput().getName());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(this.resource.getString("error.invalidinput"));
        }
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        if (this.isDirty()) {
            if (newPageIndex == 0) {
                this.syncEditors(1);
            } else if (newPageIndex == 1) {
                this.syncEditors(0);
            }
        }
        super.pageChange(newPageIndex);
    }

    public void syncEditors(int activePage) {
        if (activePage == 0) {
            String xml = StrutsConfigModel2XML.createStrutsConfig(this.graphicalEditor.getRoot());
            this.textEditor.setDiff(xml);
        } else if (activePage == 1) {
            IEditorInput input = this.textEditor.getEditorInput();
            IDocument doc = this.textEditor.getDocumentProvider().getDocument((Object)input);
            String xml = doc.get();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            IFile file = ((FileEditorInput)this.graphicalEditor.getEditorInput()).getFile();
            RootModel model = StrutsConfigXML2Model.createModel(in, this.graphicalEditor.getRoot(), (IResource)file);
            this.graphicalEditor.setRoot(model);
        }
        this.outlinePage.update();
    }

    public IDocument getDocument() {
        IEditorInput input = this.textEditor.getEditorInput();
        IDocument doc = this.textEditor.getDocumentProvider().getDocument((Object)input);
        return doc;
    }

    public void setFocus() {
        if (this.firstFlag) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                window.getActivePage().showView("org.eclipse.ui.views.ContentOutline");
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            this.firstFlag = false;
        }
        super.setFocus();
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MultiPageStrutsConfigEditor.this.updateGraphicalEditor();
            }
        });
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MultiPageStrutsConfigEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)MultiPageStrutsConfigEditor.this.graphicalEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MultiPageStrutsConfigEditor.this.graphicalEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.outlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            this.setActivePage(1);
            return this.textEditor.getAdapter(adapter);
        }
        return this.graphicalEditor.getAdapter(adapter);
    }

    private void updateGraphicalEditor() {
        this.graphicalEditor.refresh();
    }

    public XMLEditor getXMLEditor() {
        return this.textEditor;
    }

    private class SourceEditorSite
    extends MultiPageEditorSite {
        private IEditorSite site;

        public SourceEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor, IEditorSite site) {
            super(multiPageEditor, editor);
            this.site = site;
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this.site.getActionBarContributor();
        }
    }
}

