/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;

public class ManagedBean {
    private IJavaProject project;
    private String className;
    private String beanName;
    private String beanScope;
    private String managedProperty;

    public ManagedBean(IJavaProject project, String className, String beanName, String beanScope) {
        this.project = project;
        this.className = className;
        this.beanName = beanName;
        this.beanScope = beanScope;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanScope(String beanScope) {
        this.beanScope = beanScope;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getBeanScope() {
        return this.beanScope;
    }

    public String getManagedProperty() {
        return this.managedProperty;
    }

    public void setManagedProperty(String managedProperty) {
        this.managedProperty = managedProperty;
    }

    public ManagedBeanProperty[] getProperties() {
        try {
            IType type = this.project.findType(this.className);
            IMethod[] methods = this.getMethods();
            ArrayList<ManagedBeanProperty> list = new ArrayList<ManagedBeanProperty>();
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < methods.length) {
                block10: {
                    String propType;
                    String name;
                    block12: {
                        String returnType;
                        block11: {
                            name = methods[i].getElementName();
                            propType = null;
                            if (name.equals("getClass")) break block10;
                            if (!name.startsWith("get")) break block11;
                            returnType = methods[i].getReturnType();
                            if (returnType.equals("V") || methods[i].getParameterTypes().length != 0) break block10;
                            propType = Signature.toString((String)returnType);
                            break block12;
                        }
                        if (name.startsWith("set")) {
                            String[] argTypes = methods[i].getParameterTypes();
                            if (argTypes.length == 1) {
                                propType = Signature.toString((String)argTypes[0]);
                            }
                        } else if (name.startsWith("is")) {
                            returnType = methods[i].getReturnType();
                            propType = Signature.toString((String)returnType);
                        }
                    }
                    if (((name.startsWith("get") || name.startsWith("set")) && name.length() > 3 || name.startsWith("is") && name.length() > 2) && propType != null) {
                        String propName = this.getPropertyName(name);
                        if (name.startsWith("get") || name.startsWith("is") || set.contains(String.valueOf(propName) + "(" + propType + ")")) {
                            list.add(new ManagedBeanProperty(type, propName, propType));
                        } else {
                            set.add(String.valueOf(propName) + "(" + propType + ")");
                        }
                    }
                }
                ++i;
            }
            return list.toArray(new ManagedBeanProperty[list.size()]);
        }
        catch (Exception ex) {
            return new ManagedBeanProperty[0];
        }
    }

    public String[] getValidaterMethodNames() {
        try {
            IMethod[] methods = this.getMethods();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < methods.length) {
                String[] args = methods[i].getParameterTypes();
                if (methods[i].getReturnType().equals("V") && args.length == 3 && args[0].equals("QFacesContext;") && args[1].equals("QUIComponent;") && args[2].equals("QObject;")) {
                    String name = methods[i].getElementName();
                    list.add(name);
                }
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public boolean hasValidaterMethod(String methodName) {
        String[] methods = this.getValidaterMethodNames();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getValueChangeListenerMethodNames() {
        try {
            IMethod[] methods = this.getMethods();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < methods.length) {
                String[] args = methods[i].getParameterTypes();
                if (methods[i].getReturnType().equals("V") && args.length == 1 && args[0].equals("QValueChangeEvent;")) {
                    String name = methods[i].getElementName();
                    list.add(name);
                }
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public boolean hasValueChangeListenerMethod(String methodName) {
        String[] methods = this.getValueChangeListenerMethodNames();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getActionListenerMethodNames() {
        try {
            IMethod[] methods = this.getMethods();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < methods.length) {
                String[] args = methods[i].getParameterTypes();
                if (methods[i].getReturnType().equals("V") && args.length == 1 && args[0].equals("QActionEvent;")) {
                    String name = methods[i].getElementName();
                    list.add(name);
                }
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public boolean hasActionListenerMethod(String methodName) {
        String[] methods = this.getActionListenerMethodNames();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getActionMethodNames() {
        try {
            IMethod[] methods = this.getMethods();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < methods.length) {
                if ((methods[i].getReturnType().equals("QString;") || methods[i].getReturnType().equals("V")) && methods[i].getParameterTypes().length == 0) {
                    String name = methods[i].getElementName();
                    list.add(name);
                }
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public boolean hasActionMethod(String methodName) {
        String[] methods = this.getActionMethodNames();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getPropertyName(String methodName) {
        String name = null;
        name = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
        boolean flag = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z') {
                flag = true;
                break;
            }
            ++i;
        }
        if (flag) {
            name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
        }
        return name;
    }

    public boolean hasProperty(String propertyName) {
        ManagedBeanProperty[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getPropertyName().equals(propertyName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IMethod[] getMethods() throws JavaModelException {
        IType type = this.project.findType(this.className);
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].isConstructor() && !methods[i].isMainMethod() && Flags.isPublic((int)methods[i].getFlags())) {
                list.add(methods[i]);
            }
            ++i;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] superClass = hierarchy.getAllSuperclasses(type);
        int i2 = 0;
        while (i2 < superClass.length) {
            IMethod[] superMethods = superClass[i2].getMethods();
            int j = 0;
            while (j < superMethods.length) {
                if (!superMethods[j].isConstructor() && !superMethods[j].isMainMethod() && Flags.isPublic((int)superMethods[j].getFlags())) {
                    list.add(superMethods[j]);
                }
                ++j;
            }
            ++i2;
        }
        return list.toArray(new IMethod[list.size()]);
    }
}

