/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;

public class Field
implements Cloneable,
Serializable {
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property = null;
    protected String indexedProperty = null;
    protected String indexedListProperty = null;
    protected String key = null;
    protected String depends = null;
    protected int page = 0;
    protected int fieldOrder = 0;
    private List dependencyList = Collections.synchronizedList(new ArrayList());
    protected FastHashMap hVars = new FastHashMap();
    protected FastHashMap hMsgs = new FastHashMap();
    protected List defaultArgs;
    protected Map overridenArgs;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(int fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    public void setIndexedProperty(String indexedProperty) {
        this.indexedProperty = indexedProperty;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public void setIndexedListProperty(String indexedListProperty) {
        this.indexedListProperty = indexedListProperty;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
        this.dependencyList.clear();
        if (this.depends != null) {
            StringTokenizer st = new StringTokenizer(depends, ",");
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                if (depend == null || depend.length() <= 0) continue;
                this.dependencyList.add(depend);
            }
        }
    }

    public void addMsg(Msg msg) {
        this.hMsgs.put((Object)msg.getName(), (Object)msg);
    }

    public String getMsg(String key) {
        Msg msg = this.getMessage(key);
        return msg == null ? null : msg.getKey();
    }

    public Msg getMessage(String key) {
        return (Msg)this.hMsgs.get((Object)key);
    }

    public Map getMessages() {
        return Collections.unmodifiableMap(this.hMsgs);
    }

    public void addArg(Arg arg) {
        boolean isDefaultArg;
        boolean bl = isDefaultArg = arg.getName() == null;
        if (isDefaultArg) {
            if (this.defaultArgs == null) {
                this.defaultArgs = new ArrayList();
            }
            int pos = this.defaultArgs.size();
            arg.setPosition(pos);
            this.defaultArgs.add(arg);
        } else {
            int position;
            if (this.overridenArgs == null) {
                this.overridenArgs = new HashMap();
            }
            if ((position = arg.getPosition()) < 0) {
                position = this.defaultArgs == null ? 0 : this.defaultArgs.size() - 1;
                arg.setPosition(position);
            }
            this.overridenArgs.put(arg.getName() + position, arg);
        }
    }

    public Arg getArg(int position) {
        if (position < 0) {
            return null;
        }
        Arg arg = null;
        if (this.defaultArgs != null && position < this.defaultArgs.size()) {
            arg = (Arg)this.defaultArgs.get(position);
        }
        return arg;
    }

    public Arg getArg(String key, int position) {
        if (position < 0) {
            return null;
        }
        Arg arg = null;
        if (this.overridenArgs != null) {
            arg = (Arg)this.overridenArgs.get(key + position);
        }
        if (arg == null) {
            arg = this.getArg(position);
        }
        return arg;
    }

    public Arg[] getArgs(String key) {
        if (this.defaultArgs == null) {
            return new Arg[0];
        }
        Arg[] args = new Arg[this.defaultArgs.size()];
        for (int i = 0; i < this.defaultArgs.size(); ++i) {
            args[i] = this.getArg(key, i);
        }
        return args;
    }

    public void addVar(Var v) {
        this.hVars.put((Object)v.getName(), (Object)v);
    }

    public void addVar(String name, String value, String jsType) {
        this.addVar(new Var(name, value, jsType));
    }

    public Var getVar(String mainKey) {
        return (Var)this.hVars.get((Object)mainKey);
    }

    public String getVarValue(String mainKey) {
        String value = null;
        Object o = this.hVars.get((Object)mainKey);
        if (o != null && o instanceof Var) {
            Var v = (Var)o;
            value = v.getValue();
        }
        return value;
    }

    public Map getVars() {
        return Collections.unmodifiableMap(this.hVars);
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && this.indexedListProperty.length() > 0;
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    void process(Map globalConstants, Map constants) {
        String replaceValue;
        String key2;
        String key;
        this.hMsgs.setFast(false);
        this.hVars.setFast(true);
        this.generateKey();
        Iterator<Object> i = constants.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = TOKEN_START + key + TOKEN_END;
            replaceValue = (String)constants.get(key);
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        i = globalConstants.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = TOKEN_START + key + TOKEN_END;
            replaceValue = (String)globalConstants.get(key);
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        i = this.hVars.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = "${var:" + key + TOKEN_END;
            Var var = this.getVar(key);
            String replaceValue2 = var.getValue();
            this.processMessageComponents(key2, replaceValue2);
        }
        this.hMsgs.setFast(true);
    }

    private void processVars(String key, String replaceValue) {
        Iterator i = this.hVars.keySet().iterator();
        while (i.hasNext()) {
            String varKey = (String)i.next();
            Var var = this.getVar(varKey);
            var.setValue(ValidatorUtils.replace(var.getValue(), key, replaceValue));
        }
    }

    private void processMessageComponents(String key, String replaceValue) {
        String varKey = "${var:";
        if (key != null && !key.startsWith(varKey)) {
            Iterator i = this.hMsgs.values().iterator();
            while (i.hasNext()) {
                Msg msg = (Msg)i.next();
                msg.setKey(ValidatorUtils.replace(msg.getKey(), key, replaceValue));
            }
        }
        this.processArg(key, replaceValue);
    }

    private void processArg(String key, String replaceValue) {
        Arg arg;
        if (this.defaultArgs != null) {
            for (int i = 0; i < this.defaultArgs.size(); ++i) {
                arg = this.getArg(i);
                arg.setKey(ValidatorUtils.replace(arg.getKey(), key, replaceValue));
            }
        }
        if (this.overridenArgs != null) {
            Iterator iter = this.overridenArgs.values().iterator();
            while (iter.hasNext()) {
                arg = (Arg)iter.next();
                arg.setKey(ValidatorUtils.replace(arg.getKey(), key, replaceValue));
            }
        }
    }

    public boolean isDependency(String validatorName) {
        return this.dependencyList.contains(validatorName);
    }

    public List getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public Object clone() {
        Arg arg;
        Field field = new Field();
        field.setDepends(this.depends);
        field.setFieldOrder(this.fieldOrder);
        field.setIndexedListProperty(this.indexedListProperty);
        field.setIndexedProperty(this.indexedProperty);
        field.setKey(this.key);
        field.setPage(this.page);
        field.setProperty(this.property);
        if (this.defaultArgs != null) {
            for (int i = 0; i < this.defaultArgs.size(); ++i) {
                arg = this.getArg(i);
                field.addArg((Arg)arg.clone());
            }
        }
        if (this.overridenArgs != null) {
            Iterator iter = this.overridenArgs.values().iterator();
            while (iter.hasNext()) {
                arg = (Arg)iter.next();
                field.addArg((Arg)arg.clone());
            }
        }
        field.hVars = ValidatorUtils.copyFastHashMap(this.hVars);
        field.hMsgs = ValidatorUtils.copyFastHashMap(this.hMsgs);
        return field;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("\t\tkey = " + this.key + "\n");
        results.append("\t\tproperty = " + this.property + "\n");
        results.append("\t\tindexedProperty = " + this.indexedProperty + "\n");
        results.append("\t\tindexedListProperty = " + this.indexedListProperty + "\n");
        results.append("\t\tdepends = " + this.depends + "\n");
        results.append("\t\tpage = " + this.page + "\n");
        results.append("\t\tfieldOrder = " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            results.append("\t\tVars:\n");
            Iterator i = this.hVars.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                results.append("\t\t\t");
                results.append(key);
                results.append("=");
                results.append(this.hVars.get(key));
                results.append("\n");
            }
        }
        return results.toString();
    }

    Object[] getIndexedProperty(Object bean) throws ValidatorException {
        Object indexedProperty = null;
        try {
            indexedProperty = PropertyUtils.getProperty((Object)bean, (String)this.getIndexedListProperty());
        }
        catch (IllegalAccessException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ValidatorException(e.getMessage());
        }
        if (indexedProperty instanceof Collection) {
            return ((Collection)indexedProperty).toArray();
        }
        if (indexedProperty.getClass().isArray()) {
            return (Object[])indexedProperty;
        }
        throw new ValidatorException(this.getKey() + " is not indexed");
    }

    private boolean validateForRule(ValidatorAction va, ValidatorResults results, Map actions, Map params, int pos) throws ValidatorException {
        ValidatorResult result = results.getValidatorResult(this.getKey());
        if (result != null && result.containsAction(va.getName())) {
            return result.isValid(va.getName());
        }
        if (!this.runDependentValidators(va, results, actions, params, pos)) {
            return false;
        }
        return va.executeValidationMethod(this, params, results, pos);
    }

    private boolean runDependentValidators(ValidatorAction va, ValidatorResults results, Map actions, Map params, int pos) throws ValidatorException {
        List dependentValidators = va.getDependencyList();
        if (dependentValidators.isEmpty()) {
            return true;
        }
        Iterator iter = dependentValidators.iterator();
        while (iter.hasNext()) {
            String depend = (String)iter.next();
            ValidatorAction action = (ValidatorAction)actions.get(depend);
            if (action == null) {
                this.handleMissingAction(depend);
            }
            if (this.validateForRule(action, results, actions, params, pos)) continue;
            return false;
        }
        return true;
    }

    ValidatorResults validate(Map params, Map actions) throws ValidatorException {
        if (this.getDepends() == null) {
            return new ValidatorResults();
        }
        ValidatorResults allResults = new ValidatorResults();
        Object bean = params.get("java.lang.Object");
        int numberOfFieldsToValidate = this.isIndexed() ? this.getIndexedProperty(bean).length : 1;
        for (int fieldNumber = 0; fieldNumber < numberOfFieldsToValidate; ++fieldNumber) {
            Iterator dependencies = this.dependencyList.iterator();
            while (dependencies.hasNext()) {
                String depend = (String)dependencies.next();
                ValidatorAction action = (ValidatorAction)actions.get(depend);
                if (action == null) {
                    this.handleMissingAction(depend);
                }
                ValidatorResults results = new ValidatorResults();
                boolean good = this.validateForRule(action, results, actions, params, fieldNumber);
                allResults.merge(results);
                if (good) continue;
                return allResults;
            }
        }
        return allResults;
    }

    private void handleMissingAction(String name) throws ValidatorException {
        throw new ValidatorException("No ValidatorAction named " + name + " found for field " + this.getProperty());
    }
}

