/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.StrutsConfigOutlinePage;
import tk.eclipse.plugin.struts.editors.editparts.ActionEditPart;
import tk.eclipse.plugin.struts.editors.editparts.PageEditPart;
import tk.eclipse.plugin.struts.editors.editparts.StrutsConfigEditPartFactory;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class GraphicalStrutsConfigEditor
extends GraphicalEditorWithPalette {
    private RootModel root;
    private StrutsConfigOutlinePage outlinePage;
    private boolean savePreviouslyNeeded = false;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    public static final String OPEN_SELECTION = "__struts_config_open_selection";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GraphicalStrutsConfigEditor(StrutsConfigOutlinePage outlinePage) {
        this.outlinePage = outlinePage;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new DeleteRetargetAction());
        this.getActionRegistry().registerAction((IAction)new OpenAction());
    }

    public IAction getAction(Object key) {
        return this.getActionRegistry().getAction(key);
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteGroup tools = new PaletteGroup(this.resource.getString("editor.palette.group.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer flows = new PaletteDrawer(this.resource.getString("editor.palette.group.flow"));
        CreationToolEntry actionEntry = new CreationToolEntry(this.resource.getString("editor.palette.action"), this.resource.getString("editor.palette.action.tooltip"), (CreationFactory)new ActionModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_action"), StrutsPlugin.getDefault().getDescriptor("__icon_action"));
        flows.add((PaletteEntry)actionEntry);
        CreationToolEntry pageEntry = new CreationToolEntry(this.resource.getString("editor.palette.page"), this.resource.getString("editor.palette.page.tooltip"), (CreationFactory)new PageModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_webpage"), StrutsPlugin.getDefault().getDescriptor("__icon_webpage"));
        flows.add((PaletteEntry)pageEntry);
        ConnectionCreationToolEntry forwardEntry = new ConnectionCreationToolEntry(this.resource.getString("editor.palette.forward"), this.resource.getString("editor.palette.forward.tooltip"), (CreationFactory)new ForwardModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_forward"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_forward"));
        flows.add((PaletteEntry)forwardEntry);
        String string = this.resource.getString("editor.palette.exception");
        String string2 = this.resource.getString("editor.palette.exception.tooltip");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ExceptionModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectionCreationToolEntry exceptionEntry = new ConnectionCreationToolEntry(string, string2, (CreationFactory)new SimpleFactory((Class)clazz), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_exception"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_exception"));
        flows.add((PaletteEntry)exceptionEntry);
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)flows);
        return root;
    }

    public RootModel getRoot() {
        return this.root;
    }

    public void setRoot(RootModel model) {
        if (model != null) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            viewer.setContents((Object)model);
            this.root = model;
            this.root.addPropertyChangeListener(this.outlinePage);
        }
    }

    private File getBinaryFile(IFile file) {
        return new File(file.getParent().getLocation().makeAbsolute().toFile(), "." + file.getName() + ".strutside");
    }

    protected void initializeGraphicalViewer() {
        final GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        File binary = this.getBinaryFile(file);
        if (binary.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(binary));
                this.root = (RootModel)ois.readObject();
                ois.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.root = new RootModel();
            }
        } else {
            this.root = new RootModel();
            this.root.addPropertyChangeListener(this.outlinePage);
        }
        viewer.setContents((Object)this.root);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
                ((OpenAction)GraphicalStrutsConfigEditor.this.getAction(GraphicalStrutsConfigEditor.OPEN_SELECTION)).update((IStructuredSelection)viewer.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.add(this.getAction(OPEN_SELECTION));
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add(this.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        viewer.setContextMenu(menuMgr);
    }

    public void doSave() {
        this.doSave(this.getEditorInput());
    }

    public void doSave(IEditorInput input) {
        this.setInput(input);
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            File binary = this.getBinaryFile(file);
            FileOutputStream out = new FileOutputStream(binary);
            this.writeModel(out);
            out.close();
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
        this.getCommandStack().markSaveLocation();
    }

    private void writeModel(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.root);
        out.close();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void refresh() {
        this.getGraphicalViewer().getContents().refresh();
    }

    public IProject getProject() {
        return ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new StrutsConfigEditPartFactory(this));
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    private class OpenAction
    extends Action {
        private Object target;

        public OpenAction() {
            super(GraphicalStrutsConfigEditor.this.resource.getString("outline.menu.open"));
            this.setId(GraphicalStrutsConfigEditor.OPEN_SELECTION);
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            if (obj != null) {
                PageModel model;
                if (obj instanceof ActionEditPart) {
                    ActionModel model2 = (ActionModel)((ActionEditPart)obj).getModel();
                    if (!model2.getType().equals("") && model2.getType().indexOf(123) < 0) {
                        this.setEnabled(true);
                        this.target = model2;
                        return;
                    }
                } else if (obj instanceof PageEditPart && !(model = (PageModel)((PageEditPart)obj).getModel()).getPath().equals("") && model.getPath().indexOf(123) < 0) {
                    this.setEnabled(true);
                    this.target = model;
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            try {
                HTMLProjectParams params = new HTMLProjectParams(GraphicalStrutsConfigEditor.this.getProject());
                String webappRoot = params.getRoot();
                if (this.target instanceof PageModel) {
                    String path = ((PageModel)this.target).getPath();
                    if (path == null || path.equals("")) {
                        Util.openAlertDialog(GraphicalStrutsConfigEditor.this.resource.getString("error.noJspPath"));
                        return;
                    }
                    IFile file = GraphicalStrutsConfigEditor.this.getProject().getFile(String.valueOf(webappRoot) + Util.getNoQueryPath(path));
                    if (file.exists()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                    } else {
                        Util.openJSPWizard(file.getParent(), file.getName());
                    }
                } else if (this.target instanceof ActionModel) {
                    String type = ((ActionModel)this.target).getType();
                    if (type == null || type.equals("")) {
                        Util.openAlertDialog(GraphicalStrutsConfigEditor.this.resource.getString("error.noClassName"));
                        return;
                    }
                    String path = String.valueOf(type.replaceAll("\\.", "/")) + ".java";
                    IProject project = GraphicalStrutsConfigEditor.this.getProject();
                    IFile file = project.getFile(path);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] entry = javaProject.getRawClasspath();
                    int i = 0;
                    while (i < entry.length) {
                        if (entry[i].getEntryKind() == 3) {
                            file = project.getFile(entry[i].getPath().removeFirstSegments(1).append(path));
                            break;
                        }
                        ++i;
                    }
                    if (file.exists()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                    } else {
                        Util.openActionWizard(GraphicalStrutsConfigEditor.this.getProject(), type);
                    }
                }
            }
            catch (Exception ex) {
                Util.openErrorDialog(ex);
            }
        }
    }

    private class PageModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        PageModelFactory() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getNewObject() {
            try {
                try {
                    boolean cont;
                    int count = 1;
                    RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                    List children = root.getChildren();
                    block4: do {
                        cont = false;
                        int i = 0;
                        while (i < children.size()) {
                            PageModel page;
                            Object obj = children.get(i);
                            if (obj instanceof PageModel && (page = (PageModel)obj).getPath().equals("/page" + count + ".jsp")) {
                                ++count;
                                cont = true;
                                continue block4;
                            }
                            ++i;
                        }
                    } while (cont);
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                    PageModel model = new PageModel();
                    model.setPath("/page" + count + ".jsp");
                    ++count;
                    PageModel pageModel = model;
                    Object var8_12 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return pageModel;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    Object var10_11 = null;
                    Object var8_13 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return var10_11;
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                throw throwable;
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.PageModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private class ActionModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        ActionModelFactory() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getNewObject() {
            try {
                try {
                    boolean cont;
                    int count = 1;
                    RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                    List children = root.getChildren();
                    block4: do {
                        cont = false;
                        int i = 0;
                        while (i < children.size()) {
                            ActionModel action;
                            Object obj = children.get(i);
                            if (obj instanceof ActionModel && (action = (ActionModel)obj).getPath().equals("/action" + count)) {
                                ++count;
                                cont = true;
                                continue block4;
                            }
                            ++i;
                        }
                    } while (cont);
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                    ActionModel model = new ActionModel();
                    model.setPath("/action" + count);
                    ++count;
                    ActionModel actionModel = model;
                    Object var8_12 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return actionModel;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    Object var10_11 = null;
                    Object var8_13 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return var10_11;
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                throw throwable;
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ActionModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private class ForwardModelFactory
    implements CreationFactory {
        private int count = 1;
        static /* synthetic */ Class class$0;

        ForwardModelFactory() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getNewObject() {
            try {
                try {
                    boolean cont;
                    int count = 1;
                    RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                    List children = root.getChildren();
                    block4: do {
                        cont = false;
                        int i = 0;
                        while (i < children.size()) {
                            Object obj = children.get(i);
                            if (obj instanceof ActionModel) {
                                ActionModel action = (ActionModel)obj;
                                List conns = action.getModelSourceConnections();
                                int j = 0;
                                while (j < conns.size()) {
                                    ForwardModel forward;
                                    Object conn = conns.get(j);
                                    if (conn instanceof ForwardModel && (forward = (ForwardModel)conn).getName().equals("forward" + count)) {
                                        ++count;
                                        cont = true;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            if (cont) continue block4;
                            ++i;
                        }
                    } while (cont);
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                    ForwardModel model = new ForwardModel();
                    model.setName("forward" + count);
                    ++count;
                    ForwardModel forwardModel = model;
                    Object var12_16 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return forwardModel;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    Object var14_15 = null;
                    Object var12_17 = null;
                    StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                    return var14_15;
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
                throw throwable;
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ForwardModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }
}

