/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.struts.editors.editparts.AbstractStrutsConnectionEditPart;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;

public class ForwardEditPart
extends AbstractStrutsConnectionEditPart {
    private ForwardDirectEditManager directManager;
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        ForwardModel model = (ForwardModel)this.getModel();
        String name = model.getName();
        if (name.equals("")) {
            name = "<forward>";
        }
        LabelConnection connection = new LabelConnection();
        connection.setText(name);
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return connection;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ForwardDirectEditPolicy());
    }

    protected void refreshBendpoints() {
        List bendpoints = ((AbstractConnectionModel)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint((Point)bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (propName.equals("__bend_point")) {
            this.refreshBendpoints();
            return;
        }
        if (propName.equals("_name")) {
            String name = (String)evt.getNewValue();
            if (name.equals("")) {
                name = "<forward>";
            }
            LabelConnection connection = (LabelConnection)this.getFigure();
            connection.setText(name);
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new ForwardDirectEditManager(clazz, new ForwardCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class LabelConnection
    extends PolylineConnection {
        private Label label = new Label();

        public LabelConnection() {
            this.add((IFigure)this.label, new ConnectionLocator((Connection)this, 4));
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        }

        public void setText(String text) {
            this.label.setText(text);
        }
    }

    private class ForwardDirectEditManager
    extends DirectEditManager {
        public ForwardDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)ForwardEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((ForwardModel)ForwardEditPart.this.getModel()).getName());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class ForwardCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public ForwardCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = ((LabelConnection)this.figure).label.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String newName;

        DirectEditCommand() {
        }

        public void execute() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            this.oldName = model.getName();
            model.setName(this.newName);
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void undo() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            model.setName(this.oldName);
        }
    }

    private class ForwardDirectEditPolicy
    extends DirectEditPolicy {
        ForwardDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setName((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

