/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;

public class FuzzyXMLAttributeImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLAttribute {
    private String name;
    private String value;

    public FuzzyXMLAttributeImpl(String name) {
        this(null, name, null, -1, -1);
    }

    public FuzzyXMLAttributeImpl(FuzzyXMLNode parent, String name, String value, int offset, int length) {
        super(parent, offset, length);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        if (this.value == null) {
            this.value = "";
        }
        int length = this.value.length();
        this.value = value;
        this.fireModifyEvent(this.toXMLString(), this.getOffset(), this.getLength());
        this.appendOffset((FuzzyXMLElement)this.getParentNode(), this.getOffset(), value.length() - length);
    }

    public String getValue() {
        return this.value;
    }

    public String toXMLString() {
        return " " + FuzzyXMLUtil.escape(this.getName()) + "=\"" + FuzzyXMLUtil.escape(this.getValue()) + "\"";
    }

    public String toString() {
        return "attr: " + this.getName() + "=" + this.getValue();
    }
}

