/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;

public class FuzzyXMLDocTypeImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLDocType {
    private String name;
    private String publicId;
    private String systemId;
    private String internalSubset;

    public FuzzyXMLDocTypeImpl(FuzzyXMLNode parent, String name, String publicId, String systemId, String internalSubset, int offset, int length) {
        super(parent, offset, length);
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
    }

    public String getName() {
        return this.name;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE ").append(this.name);
        if (this.publicId != null && !this.publicId.equals("")) {
            sb.append(" PUBLIC ");
            sb.append("\"").append(this.publicId).append("\"");
            if (this.systemId != null && !this.systemId.equals("")) {
                sb.append(" \"").append(this.systemId).append("\"");
            }
        } else if (this.systemId != null && !this.systemId.equals("")) {
            sb.append(" SYSTEM ");
            sb.append(" \"").append(this.systemId).append("\"");
        }
        if (this.internalSubset != null && !this.internalSubset.equals("")) {
            sb.append("[").append(this.internalSubset).append("]");
        }
        sb.append(">");
        return sb.toString();
    }

    public String toString() {
        return "DOCTYPE: " + this.name;
    }
}

