/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;

public class FuzzyXMLDocumentImpl
implements FuzzyXMLDocument {
    private FuzzyXMLElement root;
    private FuzzyXMLDocType docType;
    private ArrayList listeners = new ArrayList();

    public FuzzyXMLDocumentImpl(FuzzyXMLElement root, FuzzyXMLDocType docType) {
        this.root = root;
        this.docType = docType;
        if (this.root != null) {
            ((FuzzyXMLElementImpl)this.root).setDocument(this);
            this.setDocument(this.root);
        }
        if (this.docType != null) {
            ((AbstractFuzzyXMLNode)((Object)this.docType)).setDocument(this);
        }
    }

    private void setDocument(FuzzyXMLElement element) {
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ((AbstractFuzzyXMLNode)children[i]).setDocument(this);
            if (children[i] instanceof FuzzyXMLElement) {
                this.setDocument((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
        FuzzyXMLAttribute[] attr = element.getAttributes();
        int i2 = 0;
        while (i2 < attr.length) {
            ((AbstractFuzzyXMLNode)((Object)attr[i2])).setDocument(this);
            ++i2;
        }
    }

    public FuzzyXMLComment createComment(String value) {
        return new FuzzyXMLCommentImpl(value);
    }

    public FuzzyXMLElement createElement(String name) {
        return new FuzzyXMLElementImpl(name);
    }

    public FuzzyXMLAttribute createAttribute(String name) {
        return new FuzzyXMLAttributeImpl(name);
    }

    public FuzzyXMLText createText(String value) {
        return new FuzzyXMLTextImpl(value);
    }

    public FuzzyXMLCDATA createCDATASection(String value) {
        return new FuzzyXMLCDATAImpl(value);
    }

    public FuzzyXMLProcessingInstruction createProcessingInstruction(String name, String data) {
        return new FuzzyXMLProcessingInstructionImpl(name, data);
    }

    public FuzzyXMLElement getDocumentElement() {
        return this.root;
    }

    public FuzzyXMLDocType getDocumentType() {
        return this.docType;
    }

    public FuzzyXMLElement getElementByOffset(int offset) {
        if (this.root == null) {
            return null;
        }
        ArrayList<FuzzyXMLElement> matches = new ArrayList<FuzzyXMLElement>();
        matches.add(this.root);
        this.matchOffsetElement(this.root, matches, offset);
        FuzzyXMLNode find = null;
        int i = 0;
        while (i < matches.size()) {
            FuzzyXMLElement element = (FuzzyXMLElement)matches.get(i);
            if (find == null || find.getLength() >= element.getLength()) {
                find = element;
            }
            ++i;
        }
        return find;
    }

    private void matchOffsetElement(FuzzyXMLElement element, ArrayList matches, int offset) {
        FuzzyXMLNode[] nodes = element.getChildren();
        int i = 0;
        while (i < nodes.length) {
            FuzzyXMLElement e;
            if (nodes[i] instanceof FuzzyXMLElement && (e = (FuzzyXMLElement)nodes[i]).getOffset() <= offset && offset <= e.getOffset() + e.getLength()) {
                matches.add(nodes[i]);
                this.matchOffsetElement(e, matches, offset);
            }
            ++i;
        }
    }

    public void addModifyListener(FuzzyXMLModifyListener listener) {
        this.listeners.add(listener);
    }

    public void removeModifyListener(FuzzyXMLModifyListener listener) {
        this.listeners.remove(listener);
    }

    public void fireModifyEvent(String newText, int offset, int length) {
        FuzzyXMLModifyEvent evt = new FuzzyXMLModifyEvent(newText, offset, length);
        int i = 0;
        while (i < this.listeners.size()) {
            FuzzyXMLModifyListener listener = (FuzzyXMLModifyListener)this.listeners.get(i);
            listener.modified(evt);
            ++i;
        }
    }

    public void appendOffset(FuzzyXMLElement parent, int offset, int append) {
        this.appendOffsetForElement((FuzzyXMLElementImpl)this.root, offset, append);
        this.appendLengthForParent((FuzzyXMLElementImpl)parent, append);
    }

    private void appendOffsetForElement(FuzzyXMLElementImpl element, int offset, int append) {
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getOffset() >= offset) {
                ((AbstractFuzzyXMLNode)children[i]).setOffset(children[i].getOffset() + append);
            }
            if (children[i] instanceof FuzzyXMLElementImpl) {
                this.appendOffsetForElement((FuzzyXMLElementImpl)children[i], offset, append);
            }
            ++i;
        }
        FuzzyXMLAttribute[] attr = element.getAttributes();
        int i2 = 0;
        while (i2 < attr.length) {
            if (attr[i2].getOffset() >= offset) {
                ((AbstractFuzzyXMLNode)((Object)attr[i2])).setOffset(attr[i2].getOffset() + append);
            }
            ++i2;
        }
    }

    private void appendLengthForParent(FuzzyXMLElementImpl parent, int appendLength) {
        parent.setLength(parent.getLength() + appendLength);
        if (parent.getParentNode() != null) {
            this.appendLengthForParent((FuzzyXMLElementImpl)parent.getParentNode(), appendLength);
        }
    }
}

