package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;

public class FuzzyXMLAttributeImpl extends AbstractFuzzyXMLNode implements FuzzyXMLAttribute {
	
	private String name;
	private String value;
	
	public FuzzyXMLAttributeImpl(String name) {
		this(null,name,null,-1,-1);
	}
	
	public FuzzyXMLAttributeImpl(FuzzyXMLNode parent,String name,String value,int offset,int length){
		super(parent,offset,length);
		this.name  = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setValue(String value) {
	    if(this.value==null){
	        this.value = "";
	    }
	    
	    int length = this.value.length();
		this.value = value;
	    
	    // XVCxg𔭉
		fireModifyEvent(toXMLString(),getOffset(),getLength());
		// ʒuXV
		appendOffset((FuzzyXMLElement)getParentNode(),getOffset(),value.length() - length);
	}

	public String getValue() {
		return value;
	}
	
	public String toXMLString(){
	    return " " + FuzzyXMLUtil.escape(getName()) + "=\"" + FuzzyXMLUtil.escape(getValue()) + "\""; 
	}
	
	public String toString(){
	    return "attr: " + getName() + "=" + getValue();
	}
}
