package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLException;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;


public class FuzzyXMLElementImpl extends AbstractFuzzyXMLNode implements FuzzyXMLElement {
	
	private ArrayList children   = new ArrayList();
	private ArrayList attributes = new ArrayList();
	private String name;
//	private HashMap namespace = new HashMap();
	
	public FuzzyXMLElementImpl(String name) {
		this(null,name,-1,-1);
	}
	
	public FuzzyXMLElementImpl(FuzzyXMLNode parent,String name,int offset,int length) {
		super(parent,offset,length);
		this.name = name;
	}
	
	public String getName(){
		return name;
	}
	
//	public void addNamespaceURI(String prefix,String uri){
//		if(prefix!=null){
//			namespace.put(prefix,uri);
//		}
//	}
//	
//	public String getNamespaceURI(String prefix){
//		String uri = (String)namespace.get(prefix);
//		if(uri==null){
//			FuzzyXMLElementImpl parent = this;
//			while((parent = (FuzzyXMLElementImpl)parent.getParentNode())!=null){
//				uri = parent.getNamespaceURI(prefix);
//				if(uri!=null){
//					break;
//				}
//			}
//		}
//		return uri;
//	}
	
	/**
	 * XML̒fЃeLXgqm[hQǉ܂B
	 * <p>
	 * ʏ<code>appendChild()</code>Ŏqm[hǉꍇA
	 * Xiɂ<code>FuzzyXMLNode#toXMLString()</code>̌ʂVeLXgƂĒʒm܂A
	 * ̃\bhpĎqm[hǉꍇAœneLXgVeLXgƂēn܂B
	 * sXMLp[XÃeLXgێKvꍇɎgpĂB
	 * </p>
	 * @param text ǉqvf܂XML̒fЁB
	 */
	public void appendChildrenFromText(String text){
		if(text.length()==0){
			return;
		}
		// xGg}ăItZbg擾
		FuzzyXMLElement test = new FuzzyXMLElementImpl("test");
		appendChild(test);
		int offset = test.getOffset();
		// ItZbg擾炷폜
		removeChild(test);
		
		String parseText = "<root>" + text + "</root>";
		
		FuzzyXMLElement root = new FuzzyXMLParser().parse(parseText).getDocumentElement();
		((AbstractFuzzyXMLNode)root).appendOffset(root, 0, -6);
		((AbstractFuzzyXMLNode)root).appendOffset(root, 0, offset);
		FuzzyXMLNode[] nodes = ((FuzzyXMLElement)root.getChildren()[0]).getChildren();
		
		appendOffset(this, offset, text.length());
		
		for(int i=0;i<nodes.length;i++){
			appendChild(nodes[i], false, false);
		}
		
		fireModifyEvent(text, offset, 0);
	}
	
	/**
	 * ̃GgɎqm[hǉ܂B
	 * ȉ̏ꍇ̓m[hǉ邱Ƃ͂ł܂iFuzzyXMLException܂jB
	 * 
	 * <ul>
	 *   <li>Gg̃c[ɑĂꍇieGgremoveΒǉł܂j</li>
	 *   <li>Ggqm[hĂꍇ</li>
	 * </ul>
	 * 
	 * @param node ǉm[hB
	 *   Gg̏ꍇAqȂGgw肵ĂB
	 *   łɎqvf\zς݂̃GgnƓŕێĂʒu񂪓܂B
	 *   
	 * @exception jp.aonir.fuzzyxml.FuzzyXMLException m[hǉłȂꍇ
	 */
	public void appendChild(FuzzyXMLNode node) {
		appendChild(node, true, true);
	}
	
	/**
	 * p[X<code>appendChild()</code>\bh̑Ɏgp܂B
	 */
	public void appendChildWithNoCheck(FuzzyXMLNode node){
		appendChild(node, true, false);
	}
	
	/**
	 * ̃GgɎqm[hǉB
	 * 
	 * @param node ǉm[hB
	 *   Gg̏ꍇAqȂGgw肵ĂB
	 *   łɎqvf\zς݂̃GgnƓŕێĂʒu񂪓܂B
	 * @param fireEvent Cxg𔭉΂邩ǂB
	 *   falsew肵ꍇAm[hĂʒu̓s܂B
	 * @param check ǉm[ȟ؂sǂB
	 *   truew肵ꍇAȉ̂ɊYꍇFuzzyXMLExceptionthrow܂B
	 *   <ul>
	 *     <li>m[h̃c[ɑĂꍇ</li>
	 *     <li>GgłɎqĂꍇ</li>
	 *   </ul>
	 *   p[XȂǁA؂sȂꍇfalsew肵܂B
	 *   
	 * @exception jp.aonir.fuzzyxml.FuzzyXMLException m[hǉłȂꍇ
	 */
	private void appendChild(FuzzyXMLNode node, boolean fireEvent, boolean check) {
		if(check){
			if(((AbstractFuzzyXMLNode)node).getDocument()!=null){
				throw new FuzzyXMLException("Appended node already has a parent.");
			}
			
			if(node instanceof FuzzyXMLElement){
				if(((FuzzyXMLElement)node).getChildren().length != 0){
					throw new FuzzyXMLException("Appended node has chidlren.");
				}
			}
		}
		
	    AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)node;
	    nodeImpl.setParentNode(this);
	    nodeImpl.setDocument(getDocument());
		if(node instanceof FuzzyXMLAttribute){
			setAttribute((FuzzyXMLAttribute)node);
		} else {
			if(children.contains(node)){
				return;
			}
		    if(getDocument()==null){
		        children.add(node);
		        return;
		    }
		    // ǉm[ḧʒu(Ō)vZ
		    FuzzyXMLNode[] nodes = getChildren();
		    int offset = 0;
		    if(nodes.length==0){
		        int length = getLength();
		        FuzzyXMLAttribute[] attrs = getAttributes();
		        offset = getOffset() + getName().length();
			    for(int i=0;i<attrs.length;i++){
			        offset = offset + attrs[i].toXMLString().length();
			    }
			    // H
			    offset = offset + 2;
			    
			    nodeImpl.setOffset(offset);
			    if(fireEvent){
			    	nodeImpl.setLength(node.toXMLString().length());
			    }
			    
				children.add(node);
				String xml = toXMLString();
				children.remove(node);
				
			    // Cxg̔
				if(fireEvent){
					fireModifyEvent(xml,getOffset(),getLength());
					// ʒu̍XV
					appendOffset(this,offset,xml.length() - length);
				}
				
				children.add(node);
				
		    } else {
			    for(int i=0;i<nodes.length;i++){
			        offset = nodes[i].getOffset() + nodes[i].getLength();
			    }
			    // Cxg̔
			    if(fireEvent){
			    	fireModifyEvent(nodeImpl.toXMLString(),offset,0);
					// ʒu̍XV
					appendOffset(this,offset,node.toXMLString().length());
			    }
				
				// Ōɒǉ
			    nodeImpl.setOffset(offset);
			    if(fireEvent){
			    	nodeImpl.setLength(node.toXMLString().length());
			    }
			    
		    	children.add(node);
		    }
		}
	}
	
	public FuzzyXMLAttribute[] getAttributes() {
		return (FuzzyXMLAttribute[])attributes.toArray(new FuzzyXMLAttribute[attributes.size()]);
	}
	
	public FuzzyXMLNode[] getChildren() {
	    // Agr[g͊܂܂ȂH
		return (FuzzyXMLNode[])children.toArray(new FuzzyXMLNode[children.size()]);
	}
	
	public boolean hasChildren() {
		if(children.size()==0){
			return false;
		} else {
			return true;
		}
	}
	
	public void insertBefore(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
	    // Agr[g̏ꍇ͂ȂɂȂ
	    if(newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute){
	        return;
	    }
	    // }ʒuT
	    FuzzyXMLNode target = null;
	    int index = -1;
	    FuzzyXMLNode[] children = getChildren();
	    for(int i=0;i<children.length;i++){
	        if(children[i]==refChild){
	            target = children[i];
	            index  = i;
	            break;
	        }
	    }
	    if(target==null){
	        return;
	    }
	    int offset = target.getOffset();
	    // Cxg̔
	    fireModifyEvent(newChild.toXMLString(),offset,0);
	    
	    AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
	    nodeImpl.setParentNode(this);
	    nodeImpl.setDocument(getDocument());
	    nodeImpl.setOffset(offset);
	    nodeImpl.setLength(newChild.toXMLString().length());

		// ʒu̍XV
		appendOffset(this,offset,nodeImpl.toXMLString().length());
	    
		// Ōɒǉ
	    this.children.add(index,nodeImpl);
	}
	
	public void replaceChild(FuzzyXMLNode newChild, FuzzyXMLNode refChild) {
	    // Agr[g̏ꍇ͂ȂɂȂ
	    if(newChild instanceof FuzzyXMLAttribute || refChild instanceof FuzzyXMLAttribute){
	        return;
	    }
	    // um[h̃CfbNX擾
	    int index = -1;
	    for(int i=0;i<children.size();i++){
	    	if(refChild == children.get(i)){
	    		index = i;
	    		break;
	    	}
	    }
	    // m[hȂȂɂȂ
	    if(index==-1){
	    	return;
	    }
	    children.remove(index);
	    
	    AbstractFuzzyXMLNode nodeImpl = (AbstractFuzzyXMLNode)newChild;
	    nodeImpl.setParentNode(this);
	    nodeImpl.setDocument(getDocument());
	    nodeImpl.setOffset(refChild.getOffset());
	    nodeImpl.setLength(newChild.toXMLString().length());
	    
        // Cxg̔
	    fireModifyEvent(newChild.toXMLString(),refChild.getOffset(),refChild.getLength());
        // ʒu̍XV
		appendOffset(this,refChild.getOffset(),newChild.getLength() - refChild.getLength());
		
	    children.add(index,newChild);
	}
	
	public void removeChild(FuzzyXMLNode oldChild){
	    if(oldChild instanceof FuzzyXMLAttribute){
	        removeAttributeNode((FuzzyXMLAttribute)oldChild);
	        return;
	    }
	    if(children.contains(oldChild)){
	    	// f^b`
	        ((AbstractFuzzyXMLNode)oldChild).setParentNode(null);
	        ((AbstractFuzzyXMLNode)oldChild).setDocument(null);
	        // Xg폜
	        children.remove(oldChild);
	        // Cxg̔
		    fireModifyEvent("",oldChild.getOffset(),oldChild.getLength());
	        // ʒu̍XV
			appendOffset(this,oldChild.getOffset(),oldChild.getLength() * -1);
	    }
	}
	
	public void setAttribute(FuzzyXMLAttribute attr){
	    FuzzyXMLAttribute attrNode = getAttributeNode(attr.getName());
	    if(attrNode==null){
	    	if(attributes.contains(attr)){
	    		return;
	    	}
		    if(getDocument()==null){
		        attributes.add(attr);
		        return;
		    }
	        FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attr;
	        attrImpl.setDocument(getDocument());
	        attrImpl.setParentNode(this);
	        // ǉAgr[g̈ʒu
	        FuzzyXMLAttribute[] attrs = getAttributes();
	        int offset = getOffset() + getName().length() + 1;
		    for(int i=0;i<attrs.length;i++){
		        offset = offset + attrs[i].toXMLString().length();
		    }
			// XVCxg𔭉
			fireModifyEvent(attr.toXMLString(),offset,0);
			// ʒu̍XV
			appendOffset(this,offset,attr.toXMLString().length());
			// Ōɒǉ
		    attrImpl.setOffset(offset);
		    attrImpl.setLength(attrImpl.toXMLString().length());
	        attributes.add(attrImpl);
	    } else {
	        // ̏ꍇ̓Agr[gsetValue\bhŃCxg
	        FuzzyXMLAttributeImpl attrImpl = (FuzzyXMLAttributeImpl)attrNode;
	        attrImpl.setValue(attr.getValue());
	    }
	}
	
    public FuzzyXMLAttribute getAttributeNode(String name) {
        FuzzyXMLAttribute[] attrs = getAttributes();
        for(int i=0;i<attrs.length;i++){
            if(attrs[i].getName().equals(name)){
                return attrs[i];
            }
        }
        return null;
    }
    
    public boolean hasAttribute(String name) {
        return getAttributeNode(name)!=null;
    }
    
    public void removeAttributeNode(FuzzyXMLAttribute attr){
	    if(attributes.contains(attr)){
	        // f^b`
	    	((AbstractFuzzyXMLNode)attr).setParentNode(null);
	        ((AbstractFuzzyXMLNode)attr).setDocument(null);
	        // Xg폜
	        attributes.remove(attr);
	        // Cxg̔
		    fireModifyEvent("",attr.getOffset(),attr.getLength());
	        // ʒu̍XV
			appendOffset(this,attr.getOffset(),attr.toXMLString().length() * -1);
	    }
    }
    
    public String getValue(){
        StringBuffer sb = new StringBuffer();
        FuzzyXMLNode[] children = getChildren();
        for(int i=0;i<children.length;i++){
            if(children[i] instanceof FuzzyXMLText){
                sb.append(((FuzzyXMLText)children[i]).getValue());
            }
        }
        return sb.toString();
    }
    
    public String toXMLString(){
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(FuzzyXMLUtil.escape(getName()));
        FuzzyXMLAttribute[] attrs = getAttributes();
        for(int i=0;i<attrs.length;i++){
            sb.append(attrs[i].toXMLString());
        }
        FuzzyXMLNode[] children = getChildren();
        if(children.length==0){
            sb.append("/>");
        } else {
            sb.append(">");
	        for(int i=0;i<children.length;i++){
	            sb.append(children[i].toXMLString());
	        }
	        sb.append("</").append(FuzzyXMLUtil.escape(getName())).append(">");
        }
        return sb.toString();
    }
    
    public boolean equals(Object obj){
    	if(obj instanceof FuzzyXMLElement){
    		FuzzyXMLElement element = (FuzzyXMLElement)obj;
    		
    		// ^O̖Ofalse
    		if(!element.getName().equals(getName())){
    			return false;
    		}
    		
    		// eƂnulltrue
    		FuzzyXMLNode parent = element.getParentNode();
    		if(parent==null){
    			if(getParentNode()==null){
    				return true;
    			}
    			return false;
    		}
    		
    		// JnItZbgtrue
    		if(element.getOffset()==getOffset()){
    			return true;
    		}
    		
//    		// otrue
//    		FuzzyXMLNode[] nodes = ((FuzzyXMLElement)parent).getChildren();
//    		int index1 = 0;
//    		for(int i=0;i<nodes.length;i++){
//    			if(nodes[i] instanceof FuzzyXMLElement){
//    				if(((FuzzyXMLElement)nodes[i]).getName().equals(getName())){
//    					index1++;
//    					if(nodes[i]==element){
//    						break;
//    					}
//    				}
//    			}
//    		}
//    		
//    		nodes = ((FuzzyXMLElement)getParentNode()).getChildren();
//    		int index2 = 0;
//    		for(int i=0;i<nodes.length;i++){
//    			if(nodes[i] instanceof FuzzyXMLElement){
//					if(((FuzzyXMLElement)nodes[i]).getName().equals(getName())){
//						index2++;
//    					if(nodes[i]==this){
//    						break;
//    					}
//					}
//    			}
//    		}
//    		
//    		if(index1==index2){
//    			return true;
//    		}
    		
//    		// bodyetrue
//    		if(toXMLString().equals(((FuzzyXMLElement)obj).toXMLString())){
//    			return true;
//    		}
    	}
    	return false;
    }
    
	public void setDocument(FuzzyXMLDocumentImpl doc){
	    super.setDocument(doc);
	    FuzzyXMLNode[] nodes = getChildren();
	    for(int i=0;i<nodes.length;i++){
	    	((AbstractFuzzyXMLNode)nodes[i]).setDocument(doc);
	    }
	    FuzzyXMLAttribute[] attrs = getAttributes();
	    for(int i=0;i<attrs.length;i++){
	    	((AbstractFuzzyXMLNode)attrs[i]).setDocument(doc);
	    }
	}
    
    public String toString(){
        return "element: " + getName();
    }
    
    public void removeAllChildren(){
    	FuzzyXMLNode[] children = getChildren();
    	for(int i=0;i<children.length;i++){
    		removeChild(children[i]);
    	}
    }
}
