/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.ajax.api;

import java.io.IOException;
import java.io.PrintWriter;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.jsp.JspStateManagerImpl;
import org.apache.myfaces.custom.ajax.api.AjaxComponent;
import org.apache.myfaces.custom.buffer.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.renderkit.RendererUtils;

public class AjaxPhaseListener
implements PhaseListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$ajax$api$AjaxPhaseListener == null ? (class$org$apache$myfaces$custom$ajax$api$AjaxPhaseListener = AjaxPhaseListener.class$("org.apache.myfaces.custom.ajax.api.AjaxPhaseListener")) : class$org$apache$myfaces$custom$ajax$api$AjaxPhaseListener));
    static /* synthetic */ Class class$org$apache$myfaces$custom$ajax$api$AjaxPhaseListener;

    public static Object getValueForComponent(FacesContext facesContext, UIComponent component) {
        String possibleClientId = component.getClientId(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(possibleClientId)) {
            return facesContext.getExternalContext().getRequestParameterMap().get(possibleClientId);
        }
        possibleClientId = (String)facesContext.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent");
        UIViewRoot root = facesContext.getViewRoot();
        UIComponent ajaxComponent = root.findComponent(possibleClientId);
        if (ajaxComponent == component) {
            return facesContext.getExternalContext().getRequestParameterMap().get(possibleClientId);
        }
        log.error((Object)("No value found for this component : " + possibleClientId));
        return null;
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context.getExternalContext().getRequestParameterMap().containsKey("affectedAjaxComponent")) {
            UIViewRoot root = context.getViewRoot();
            UIComponent ajaxComponent = root.findComponent((String)context.getExternalContext().getRequestParameterMap().get("affectedAjaxComponent"));
            if (ajaxComponent instanceof AjaxComponent) {
                try {
                    HtmlBufferResponseWriterWrapper wrapper = HtmlBufferResponseWriterWrapper.getInstance(null);
                    context.setResponseWriter((ResponseWriter)wrapper);
                    ((AjaxComponent)ajaxComponent).encodeAjax(context);
                    StringBuffer buf = new StringBuffer(wrapper.toString());
                    buf.insert(0, Integer.toHexString(buf.length()) + "\r\n");
                    buf.append("\r\n0\r\n\r\n");
                    if (context.getExternalContext().getResponse() instanceof HttpServletResponse) {
                        ((HttpServletResponse)context.getExternalContext().getResponse()).addHeader("Transfer-Encoding", "chunked");
                        PrintWriter writer = ((HttpServletResponse)context.getExternalContext().getResponse()).getWriter();
                        writer.print(buf.toString());
                        writer.flush();
                        writer.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Exception while rendering ajax-response", (Throwable)e);
                }
            } else {
                log.error((Object)("Found component is no ajaxComponent : " + RendererUtils.getPathToComponent(ajaxComponent)));
            }
            if (!context.getApplication().getStateManager().isSavingStateInClient(context)) {
                ((JspStateManagerImpl)context.getApplication().getStateManager()).saveSerializedView(context);
            }
            context.responseComplete();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.INVOKE_APPLICATION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

