/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.form;

import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.custom.form.HtmlForm;
import org.apache.myfaces.renderkit.html.HtmlFormRendererBase;

public class HtmlFormRenderer
extends HtmlFormRendererBase {
    protected String getActionUrl(FacesContext facesContext, UIForm form) {
        String actionUrl = super.getActionUrl(facesContext, form);
        if (form instanceof HtmlForm) {
            Object request;
            HtmlForm htmlForm = (HtmlForm)form;
            String scheme = htmlForm.getScheme();
            String serverName = htmlForm.getServerName();
            Integer portObj = htmlForm.getPort();
            if ((scheme != null || serverName != null || portObj != null) && (request = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                int serverPort = 0;
                serverPort = portObj == null ? httpRequest.getServerPort() : portObj.intValue();
                if (scheme == null) {
                    scheme = httpRequest.getScheme();
                } else if (portObj == null) {
                    serverPort = 0;
                }
                if (serverName == null) {
                    serverName = httpRequest.getServerName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(scheme);
                sb.append("://");
                sb.append(serverName);
                if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
                    sb.append(":");
                    sb.append(serverPort);
                }
                sb.append(actionUrl);
                actionUrl = sb.toString();
            }
        }
        return actionUrl;
    }
}

