/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.model.ScheduleModel;

public abstract class AbstractScheduleModel
implements ScheduleModel {
    protected final TreeSet days = new TreeSet();
    private Date selectedDate;
    private ScheduleEntry selectedEntry;
    private int mode;

    public boolean isEmpty() {
        return this.days.isEmpty();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setSelectedDate(Date date) {
        this.selectedDate = date;
        switch (this.mode) {
            case 0: {
                this.setDay(date);
                break;
            }
            case 1: {
                this.setWorkWeek(date);
                break;
            }
            case 2: {
                this.setWeek(date);
                break;
            }
            case 3: {
                this.setMonth(date);
                break;
            }
            default: {
                this.setDay(date);
            }
        }
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedEntry(ScheduleEntry selectedEntry) {
        this.selectedEntry = selectedEntry;
    }

    public ScheduleEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public boolean containsDate(Date date) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)iterator.next();
            if (!day.equalsDate(date)) continue;
            return true;
        }
        return false;
    }

    public Object get(int index) {
        Object[] dayArray = this.days.toArray();
        Object returnObject = dayArray[index];
        return returnObject;
    }

    public Iterator iterator() {
        return this.days.iterator();
    }

    public int size() {
        return this.days.size();
    }

    protected void setDay(Date date) {
        this.clear();
        if (date == null) {
            return;
        }
        ScheduleDay day = this.add(date);
        this.load(day.getDayStart(), day.getDayEnd());
    }

    protected void setMonth(Date date) {
        this.clear();
        if (date == null) {
            return;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getMinimum(5));
        int currentMonth = cal.get(2);
        Day firstDay = null;
        Day lastDay = null;
        while (cal.get(2) == currentMonth) {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        }
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected void setWeek(Date date) {
        this.clear();
        if (date == null) {
            return;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(7, 2);
        Day firstDay = null;
        Day lastDay = null;
        for (int i = 0; i < 7; ++i) {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        }
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected void setWorkWeek(Date date) {
        this.clear();
        if (date == null) {
            return;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(7, 2);
        Day firstDay = null;
        Day lastDay = null;
        for (int i = 0; i < 5; ++i) {
            ScheduleDay addedDay = this.add(cal.getTime());
            if (firstDay == null) {
                firstDay = addedDay;
            }
            lastDay = addedDay;
            cal.add(5, 1);
        }
        this.load(firstDay.getDayStart(), lastDay.getDayEnd());
    }

    protected ScheduleDay add(Date date) {
        if (date == null) {
            return null;
        }
        ScheduleDay day = new ScheduleDay(date);
        this.loadDayAttributes(day);
        this.days.add(day);
        return day;
    }

    protected void clear() {
        Iterator dayIterator = this.days.iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            day.clear();
        }
        this.days.clear();
    }

    public void refresh() {
        this.setSelectedDate(this.selectedDate);
    }

    protected abstract Collection loadEntries(Date var1, Date var2);

    protected abstract void loadDayAttributes(Day var1);

    private void load(Date startDate, Date endDate) {
        Collection entries = this.loadEntries(startDate, endDate);
        Iterator entryIterator = entries.iterator();
        while (entryIterator.hasNext()) {
            ScheduleEntry entry = (ScheduleEntry)entryIterator.next();
            Iterator dayIterator = this.days.iterator();
            while (dayIterator.hasNext()) {
                ScheduleDay day = (ScheduleDay)dayIterator.next();
                day.addEntry(entry);
            }
        }
    }
}

