/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class PlannerEntity
implements Serializable {
    private final String id;
    private final String name;
    private TreeSet entries;

    public PlannerEntity(String id, String name) {
        this.id = id;
        this.name = name;
        this.entries = new TreeSet(new ScheduleEntryComparator());
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void setEntries(TreeSet entries) {
        this.entries = entries;
    }

    public TreeSet getEntries() {
        return this.entries;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean addEntry(ScheduleEntry entry) {
        if (entry == null || entry.getStartTime() == null || entry.getEndTime() == null) {
            return false;
        }
        this.entries.add(entry);
        return true;
    }

    public void clear() {
        this.entries.clear();
    }

    public boolean equals(Object o) {
        if (o instanceof PlannerEntity) {
            PlannerEntity other = (PlannerEntity)o;
            return this.id.equals(other.id);
        }
        return false;
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public boolean remove(ScheduleEntry entry) {
        return this.entries.remove(entry);
    }

    public int size() {
        return this.entries.size();
    }
}

