/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.PlannerEntity;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;

public class PlannerModel
implements Serializable {
    private HashMap entities;
    private TreeSet days = new TreeSet();

    public PlannerModel() {
        this.entities = new HashMap();
    }

    public boolean setDay(Date date) {
        if (date == null) {
            return false;
        }
        this.days.clear();
        this.add(date);
        return true;
    }

    public Day getDay(int index) {
        Object[] dayArray = this.days.toArray();
        return (Day)dayArray[index];
    }

    public PlannerEntity getEntity(String id) {
        return (PlannerEntity)this.entities.get(id);
    }

    public boolean setSpecialDay(Date date, boolean isWorkingDay, String specialDayName) {
        if (date == null || !this.containsDate(date)) {
            return false;
        }
        Iterator dayIterator = this.dayIterator();
        while (dayIterator.hasNext()) {
            Day day = (Day)dayIterator.next();
            day.setWorkingDay(isWorkingDay);
            day.setSpecialDayName(specialDayName);
        }
        return true;
    }

    public Day add(Date date, boolean isWorkingDay, String specialDayName) {
        if (date == null) {
            return null;
        }
        Day day = new Day(date);
        day.setWorkingDay(isWorkingDay);
        day.setSpecialDayName(specialDayName);
        this.days.add(day);
        return day;
    }

    public boolean add(PlannerEntity entity) {
        if (entity == null || this.entities.containsKey(entity.getId())) {
            return false;
        }
        this.entities.put(entity.getId(), entity);
        return true;
    }

    public PlannerEntity add(String id, String name) {
        PlannerEntity entity = new PlannerEntity(id, name);
        if (this.add(entity)) {
            return entity;
        }
        return null;
    }

    public Day add(Day day) {
        if (day != null) {
            this.days.add(day);
        }
        return day;
    }

    public Day add(Date date) {
        return this.add(date, true, null);
    }

    public boolean addEntry(String entityId, ScheduleEntry entry) {
        PlannerEntity entity = this.getEntity(entityId);
        if (entity == null) {
            return false;
        }
        return entity.addEntry(entry);
    }

    public void clear() {
        this.days.clear();
        this.entities.clear();
    }

    public boolean containsDate(Date date) {
        Iterator iterator = this.days.iterator();
        while (iterator.hasNext()) {
            Day day = (Day)iterator.next();
            if (!day.equalsDate(date)) continue;
            return true;
        }
        return false;
    }

    public Iterator dayIterator() {
        return this.days.iterator();
    }

    public Iterator entityIterator() {
        return this.entities.values().iterator();
    }

    public int numberOfDays() {
        return this.days.size();
    }

    public int numberOfEntities() {
        return this.entities.size();
    }
}

