/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class ScheduleDay
extends Day
implements Serializable,
Comparable {
    private final TreeSet entries = new TreeSet(new ScheduleEntryComparator());

    public ScheduleDay(Date date) {
        super(date);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean addEntry(ScheduleEntry entry) {
        if (entry == null || entry.getStartTime() == null || entry.getEndTime() == null) {
            return false;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(entry.getEndTime());
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        cal.setTime(entry.getStartTime());
        while (cal.getTime().before(endDate)) {
            if (this.equalsDate(cal.getTime())) {
                this.entries.add(entry);
                return true;
            }
            cal.add(5, 1);
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public boolean remove(ScheduleEntry entry) {
        return this.entries.remove(entry);
    }

    public int size() {
        return this.entries.size();
    }
}

