/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.AbstractScheduleRenderer;

public abstract class AbstractCompactScheduleRenderer
extends AbstractScheduleRenderer {
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    protected abstract int getDefaultRowHeight();

    protected abstract String getRowHeightProperty();

    protected int getRowHeight(Map attributes) {
        int rowHeight = 0;
        try {
            rowHeight = Integer.valueOf((String)attributes.get(this.getRowHeightProperty()));
        }
        catch (Exception e) {
            rowHeight = 0;
        }
        if (rowHeight <= 0) {
            rowHeight = this.getDefaultRowHeight();
        }
        return rowHeight;
    }

    protected void writeDayCell(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, float cellWidth, int dayOfWeek, int dayOfMonth, boolean isWeekend, boolean isCurrentMonth, int rowspan) throws IOException {
        Map attributes = schedule.getAttributes();
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("rowspan", (Object)String.valueOf(rowspan), null);
        writer.writeAttribute("class", (Object)(isCurrentMonth ? "day" : "inactive-day"), null);
        StringBuffer styleBuffer = new StringBuffer();
        styleBuffer.append("height: ");
        int myRowHeight = 0;
        int myContentHeight = 0;
        if (isWeekend) {
            myRowHeight = this.getRowHeight(attributes) / 2;
            myContentHeight = myRowHeight - 19;
        } else {
            myRowHeight = this.getRowHeight(attributes) + 1;
            myContentHeight = myRowHeight - 18;
        }
        styleBuffer.append(myRowHeight);
        styleBuffer.append("px;");
        writer.writeAttribute("style", (Object)(styleBuffer.toString() + " width: " + cellWidth + "%;"), null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"day", null);
        writer.writeAttribute("style", (Object)(styleBuffer.toString() + " width: 100%;"), null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"header", null);
        writer.writeAttribute("style", (Object)"height: 18px; width: 100%; overflow: hidden", null);
        writer.writeText((Object)this.getDateString(context, (UIComponent)schedule, day.getDate()), null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"content", null);
        StringBuffer contentStyleBuffer = new StringBuffer();
        contentStyleBuffer.append("height: ");
        contentStyleBuffer.append(myContentHeight);
        contentStyleBuffer.append("px; width: 100%;");
        writer.writeAttribute("style", (Object)contentStyleBuffer.toString(), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%; overflow: auto; vertical-align: top;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 100%;", null);
        this.writeEntries(context, schedule, day, writer);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
    }

    protected void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        ScheduleEntry entry;
        UIForm parentForm = this.getParentForm((UIComponent)schedule);
        TreeSet<ScheduleEntry> entrySet = new TreeSet<ScheduleEntry>(comparator);
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            entry = (ScheduleEntry)entryIterator.next();
            entrySet.add(entry);
        }
        entryIterator = entrySet.iterator();
        while (entryIterator.hasNext()) {
            entry = (ScheduleEntry)entryIterator.next();
            writer.startElement("tr", (UIComponent)schedule);
            writer.startElement("td", (UIComponent)schedule);
            if (this.isSelected(schedule, entry)) {
                writer.writeAttribute("class", (Object)"selected", null);
            }
            writer.writeAttribute("style", (Object)"width: 100%", null);
            if (this.showTooltip((UIComponent)schedule)) {
                writer.writeAttribute("onmouseover", (Object)this.getTooltipText(entry, (UIComponent)schedule), null);
            }
            if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                writer.startElement("a", (UIComponent)schedule);
                writer.writeAttribute("href", (Object)"#", null);
                String clientId = schedule.getClientId(context);
                StringBuffer mousedown = new StringBuffer();
                mousedown.append("document.forms['");
                mousedown.append(parentForm.getClientId(context));
                mousedown.append("']['");
                mousedown.append(clientId);
                mousedown.append("'].value='");
                mousedown.append(entry.getId());
                mousedown.append("'; document.forms['");
                mousedown.append(parentForm.getClientId(context));
                mousedown.append("'].submit()");
                writer.writeAttribute("onmousedown", (Object)mousedown.toString(), null);
            }
            writer.writeText((Object)this.getEntryText(day, entry), null);
            if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                writer.endElement("a");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    private String getEntryText(Day day, ScheduleEntry entry) {
        StringBuffer text = new StringBuffer();
        Date startTime = entry.getStartTime();
        if (day.getDayStart().after(entry.getStartTime())) {
            startTime = day.getDayStart();
        }
        Date endTime = entry.getEndTime();
        if (day.getDayEnd().before(entry.getEndTime())) {
            endTime = day.getDayEnd();
        }
        DateFormat format = DateFormat.getTimeInstance(3);
        text.append(format.format(startTime));
        text.append("-");
        text.append(format.format(endTime));
        text.append(": ");
        text.append(entry.getTitle());
        String returnString = text.toString();
        return returnString;
    }

    private boolean isSelected(HtmlSchedule schedule, ScheduleEntry entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        return selectedEntry.getId().equals(entry.getId());
    }
}

