/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.custom.schedule.HtmlPlanner;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.PlannerEntity;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class PlannerRenderer
extends Renderer {
    private static final ScheduleEntryComparator comparator = new ScheduleEntryComparator();
    private final int ROW_HEIGHT_IN_PIXELS = 22;
    static /* synthetic */ Class class$org$apache$myfaces$custom$schedule$HtmlPlanner;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlPlanner planner = (HtmlPlanner)component;
        ResponseWriter writer = context.getResponseWriter();
        String theme = this.getTheme((UIComponent)planner);
        if (theme == null || theme.length() < 1) {
            theme = "default";
        }
        String css = "css/" + theme + ".css";
        AddResource.addStyleSheet((Class)(class$org$apache$myfaces$custom$schedule$HtmlPlanner == null ? (class$org$apache$myfaces$custom$schedule$HtmlPlanner = PlannerRenderer.class$("org.apache.myfaces.custom.schedule.HtmlPlanner")) : class$org$apache$myfaces$custom$schedule$HtmlPlanner), (String)css, (FacesContext)context);
        AddResource.addJavaScriptToHeader((Class)(class$org$apache$myfaces$custom$schedule$HtmlPlanner == null ? (class$org$apache$myfaces$custom$schedule$HtmlPlanner = PlannerRenderer.class$("org.apache.myfaces.custom.schedule.HtmlPlanner")) : class$org$apache$myfaces$custom$schedule$HtmlPlanner), (String)"javascript/alphaAPI.js", (FacesContext)context);
        AddResource.addJavaScriptToHeader((Class)(class$org$apache$myfaces$custom$schedule$HtmlPlanner == null ? (class$org$apache$myfaces$custom$schedule$HtmlPlanner = PlannerRenderer.class$("org.apache.myfaces.custom.schedule.HtmlPlanner")) : class$org$apache$myfaces$custom$schedule$HtmlPlanner), (String)"javascript/domLib.js", (FacesContext)context);
        AddResource.addJavaScriptToHeader((Class)(class$org$apache$myfaces$custom$schedule$HtmlPlanner == null ? (class$org$apache$myfaces$custom$schedule$HtmlPlanner = PlannerRenderer.class$("org.apache.myfaces.custom.schedule.HtmlPlanner")) : class$org$apache$myfaces$custom$schedule$HtmlPlanner), (String)"javascript/domTT.js", (FacesContext)context);
        AddResource.addJavaScriptToHeader((Class)(class$org$apache$myfaces$custom$schedule$HtmlPlanner == null ? (class$org$apache$myfaces$custom$schedule$HtmlPlanner = PlannerRenderer.class$("org.apache.myfaces.custom.schedule.HtmlPlanner")) : class$org$apache$myfaces$custom$schedule$HtmlPlanner), (String)"javascript/fadomatic.js", (FacesContext)context);
        int numberOfRows = planner.getModel().numberOfEntities();
        int gridHeight = numberOfRows * 22 + 3 + 47;
        writer.startElement("div", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"planner", null);
        writer.writeAttribute("style", (Object)("height: " + String.valueOf(gridHeight) + "px; overflow: hidden;"), null);
        this.writeBackground(context, planner, writer);
        this.writeForegroundStart(context, planner, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlPlanner planner = (HtmlPlanner)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator entityIterator = planner.getModel().entityIterator();
        while (entityIterator.hasNext()) {
            PlannerEntity entity = (PlannerEntity)entityIterator.next();
            writer.startElement("tr", (UIComponent)planner);
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"gutter", null);
            writer.startElement("div", (UIComponent)planner);
            writer.writeAttribute("style", (Object)("height: 1px; width: " + String.valueOf(this.getGutterWidth((UIComponent)planner)) + "px"), null);
            writer.endElement("div");
            writer.endElement("td");
            int numberOfDays = planner.getModel().numberOfDays();
            float columnWidth = numberOfDays == 0 ? 100.0f : (float)(100 / numberOfDays);
            Iterator dayIterator = planner.getModel().dayIterator();
            while (dayIterator.hasNext()) {
                Day day = (Day)dayIterator.next();
                writer.startElement("td", (UIComponent)planner);
                writer.writeAttribute("class", (Object)"row", null);
                writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
                writer.writeAttribute("style", (Object)"height: 21px; border-left-style: solid; border-left-width: 1px; border-top-style: none; border-right-style: none; border-bottom-style: none;", null);
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"row", null);
                writer.writeAttribute("styleClass", (Object)"position: relative; top: 0px; left: 0px; width: 100%; height: 100%; padding: 0px; z-index: 0; vertical-align: middle;", null);
                this.writeEntries(context, planner, entity, day, writer);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlPlanner planner = (HtmlPlanner)component;
        ResponseWriter writer = context.getResponseWriter();
        this.writeForegroundEnd(context, planner, writer);
        writer.endElement("div");
    }

    protected int getGutterWidth(UIComponent component) {
        try {
            Integer value;
            ValueBinding binding = component.getValueBinding("gutterWidthInPixels");
            if (binding != null && (value = (Integer)binding.getValue(FacesContext.getCurrentInstance())) != null) {
                return value;
            }
            Map attributes = component.getAttributes();
            Integer width = Integer.valueOf((String)attributes.get("gutterWidthInPixels"));
            return width;
        }
        catch (NumberFormatException nfe) {
            return 200;
        }
    }

    protected String getHeaderDateFormat(UIComponent component) {
        String value;
        ValueBinding binding = component.getValueBinding("headerDateFormat");
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return (String)attributes.get("headerDateFormat");
    }

    protected UIForm getParentForm(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    protected boolean showLegend(UIComponent component) {
        Boolean value;
        ValueBinding binding = component.getValueBinding("legend");
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return Boolean.valueOf((String)attributes.get("legend"));
    }

    protected String getTheme(UIComponent component) {
        String value;
        ValueBinding binding = component.getValueBinding("theme");
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return (String)attributes.get("theme");
    }

    protected boolean showTooltip(UIComponent component) {
        Boolean value;
        ValueBinding binding = component.getValueBinding("tooltip");
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        return Boolean.valueOf((String)attributes.get("tooltip"));
    }

    private String getCellClass(HtmlPlanner planner, Day day, int hour) {
        if (!day.isWorkingDay()) {
            return "free";
        }
        if (hour >= planner.getWorkingStartHour() && hour < planner.getWorkingEndHour()) {
            return hour % 2 == 0 ? "even" : "uneven";
        }
        return "free";
    }

    private String getDateString(FacesContext context, UIComponent component, Date date) {
        String pattern = this.getHeaderDateFormat(component);
        DateFormat format = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : (context.getApplication().getDefaultLocale() != null ? DateFormat.getDateInstance(2, context.getApplication().getDefaultLocale()) : DateFormat.getDateInstance(2));
        return format.format(date);
    }

    private String getTooltipText(ScheduleEntry entry, UIComponent component) {
        if (!this.showTooltip(component)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("return makeTrue(domTT_activate(this, event, 'caption', '");
        if (entry.getTitle() != null) {
            buffer.append(this.escape(entry.getTitle()));
        }
        buffer.append("', 'content', '<i>");
        if (entry.getSubtitle() != null) {
            buffer.append(this.escape(entry.getSubtitle()));
        }
        buffer.append("</i>");
        if (entry.getDescription() != null) {
            buffer.append("<br/>");
            buffer.append(this.escape(entry.getDescription()));
        }
        buffer.append("', 'trail', true));");
        return buffer.toString();
    }

    private boolean containsEntry(HtmlPlanner planner, Day day, ScheduleEntry entry) {
        if (day == null || entry == null) {
            return false;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(day.getDate());
        cal.set(11, planner.getVisibleStartHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date dayStart = cal.getTime();
        cal.set(11, planner.getVisibleEndHour());
        Date dayEnd = cal.getTime();
        return entry.getEndTime().after(dayStart) && entry.getStartTime().before(dayEnd);
    }

    private String escape(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("'", "&quot;");
    }

    private void writeBackground(FacesContext context, HtmlPlanner planner, ResponseWriter writer) throws IOException {
        UIForm parentForm = this.getParentForm((UIComponent)planner);
        if (parentForm == null) {
            throw new NullPointerException("No parent UIForm found");
        }
        writer.startElement("div", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"background", null);
        writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; z-index: 0;", null);
        writer.startElement("table", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"background", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%;", null);
        writer.startElement("tbody", (UIComponent)planner);
        writer.startElement("tr", (UIComponent)planner);
        writer.startElement("td", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"gutter", null);
        writer.writeAttribute("rowspan", (Object)"2", null);
        writer.writeAttribute("style", (Object)"padding: 0px; vertical-align: middle; height: 21px; border-style: none; border-width: 0px; overflow: hidden; whitespace: nowrap;", null);
        writer.startElement("div", (UIComponent)planner);
        writer.writeAttribute("style", (Object)("height: 1px; width: " + String.valueOf(this.getGutterWidth((UIComponent)planner)) + "px"), null);
        writer.endElement("div");
        writer.endElement("td");
        int numberOfDays = planner.getModel().numberOfDays();
        float columnWidth = numberOfDays == 0 ? 100.0f : (float)(100 / numberOfDays);
        Iterator dayIterator = planner.getModel().dayIterator();
        while (dayIterator.hasNext()) {
            Day day = (Day)dayIterator.next();
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"header", null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.writeAttribute("style", (Object)"overflow: hidden; height: 31px;", null);
            writer.startElement("div", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"header", null);
            writer.writeAttribute("style", (Object)"position: relative; left: 0px; top: 0px; width: 100%; height: 100%;", null);
            writer.startElement("span", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"date", null);
            writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 15px; overflow: hidden; white-space: nowrap;", null);
            writer.writeText((Object)this.getDateString(context, (UIComponent)planner, day.getDate()), null);
            writer.endElement("span");
            if (day.getSpecialDayName() != null && day.getSpecialDayName().length() > 0) {
                writer.startElement("span", (UIComponent)planner);
                writer.writeAttribute("class", (Object)"holiday", null);
                writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 15px; width: 100%; overflow: hidden; white-space: nowrap;", null);
                writer.writeText((Object)day.getSpecialDayName(), null);
                writer.endElement("span");
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)planner);
        int numberOfHours = planner.getVisibleEndHour() - planner.getVisibleStartHour();
        float hourWidth = numberOfHours <= 0 ? 100.0f : (float)(100 / numberOfHours);
        Iterator dayIterator2 = planner.getModel().dayIterator();
        while (dayIterator2.hasNext()) {
            Day day = (Day)dayIterator2.next();
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.startElement("table", (UIComponent)planner);
            writer.writeAttribute("style", (Object)"height: 100%; width: 100%", null);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.startElement("tr", (UIComponent)planner);
            for (int hcol = planner.getVisibleStartHour(); hcol < planner.getVisibleEndHour(); ++hcol) {
                writer.startElement("td", (UIComponent)planner);
                writer.writeAttribute("class", (Object)"hours", null);
                writer.writeAttribute("width", (Object)(String.valueOf(hourWidth) + "%"), null);
                writer.writeAttribute("style", (Object)"overflow: hidden; height: 15px; border-left-style: solid; border-left-width: 1px; border-top-style: none; border-right-style: none; border-bottom-style: none;", null);
                writer.startElement("div", (UIComponent)planner);
                writer.writeAttribute("class", (Object)"header", null);
                writer.writeAttribute("style", (Object)"position: relative; left: 0px; top: 0px; width: 100%; height: 100%;", null);
                writer.startElement("span", (UIComponent)planner);
                writer.writeAttribute("class", (Object)"hours", null);
                writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; overflow: hidden; white-space: nowrap;", null);
                writer.writeText((Object)(String.valueOf(hcol) + ":00"), null);
                writer.endElement("span");
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
        }
        writer.endElement("tr");
        Iterator entityIterator = planner.getModel().entityIterator();
        while (entityIterator.hasNext()) {
            PlannerEntity entity = (PlannerEntity)entityIterator.next();
            writer.startElement("tr", (UIComponent)planner);
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"gutter", null);
            writer.writeAttribute("style", (Object)"padding: 0px; vertical-align: middle; height: 21px; border-style: none; border-width: 0px; overflow: hidden; whitespace: nowrap;", null);
            writer.startElement("span", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"title", null);
            writer.writeAttribute("style", (Object)"height: 100%;", null);
            writer.writeText((Object)entity.getName(), null);
            writer.endElement("span");
            writer.endElement("td");
            Iterator dayIterator3 = planner.getModel().dayIterator();
            while (dayIterator3.hasNext()) {
                Day day = (Day)dayIterator3.next();
                writer.startElement("td", (UIComponent)planner);
                writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
                writer.startElement("table", (UIComponent)planner);
                writer.writeAttribute("style", (Object)"height: 100%; width: 100%", null);
                writer.writeAttribute("cellpadding", (Object)"0", null);
                writer.writeAttribute("cellspacing", (Object)"0", null);
                writer.writeAttribute("border", (Object)"0", null);
                writer.startElement("tr", (UIComponent)planner);
                for (int hcol = planner.getVisibleStartHour(); hcol < planner.getVisibleEndHour(); ++hcol) {
                    writer.startElement("td", (UIComponent)planner);
                    writer.writeAttribute("class", (Object)this.getCellClass(planner, day, hcol), null);
                    writer.writeAttribute("width", (Object)(String.valueOf(hourWidth) + "%"), null);
                    writer.writeAttribute("style", (Object)"height: 21px; overflow: hidden; border-left-style: solid; border-left-width: 1px; border-top-style: none; border-right-style: none; border-bottom-style: none;", null);
                    writer.write("&#160;");
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("table");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeEntries(FacesContext context, HtmlPlanner planner, PlannerEntity entity, Day day, ResponseWriter writer) throws IOException {
        Iterator entryIterator = entity.iterator();
        while (entryIterator.hasNext()) {
            ScheduleEntry entry = (ScheduleEntry)entryIterator.next();
            if (!this.containsEntry(planner, day, entry)) continue;
            EntryWrapper wrapper = new EntryWrapper(entry, day, entity);
            writer.startElement("div", (UIComponent)planner);
            if (this.showTooltip((UIComponent)planner)) {
                writer.writeAttribute("onmouseover", (Object)this.getTooltipText(wrapper.entry, (UIComponent)planner), null);
            }
            writer.writeAttribute("class", (Object)"entry", null);
            writer.writeAttribute("style", (Object)wrapper.getBounds(planner), null);
            writer.endElement("div");
        }
    }

    private void writeForegroundEnd(FacesContext context, HtmlPlanner planner, ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeForegroundStart(FacesContext context, HtmlPlanner planner, ResponseWriter writer) throws IOException {
        Day day;
        writer.startElement("div", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"foreground", null);
        writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; z-index: 1;", null);
        writer.startElement("table", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"foreground", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%;", null);
        writer.startElement("tbody", (UIComponent)planner);
        writer.startElement("tr", (UIComponent)planner);
        writer.startElement("td", (UIComponent)planner);
        writer.writeAttribute("class", (Object)"gutter", null);
        writer.writeAttribute("rowspan", (Object)"2", null);
        writer.writeAttribute("style", (Object)"padding: 0px; vertical-align: middle; height: 21px; border-style: none; border-width: 0px; overflow: hidden; whitespace: nowrap;", null);
        writer.startElement("div", (UIComponent)planner);
        writer.writeAttribute("style", (Object)("height: 1px; width: " + String.valueOf(this.getGutterWidth((UIComponent)planner)) + "px"), null);
        writer.endElement("div");
        writer.endElement("td");
        int numberOfDays = planner.getModel().numberOfDays();
        float columnWidth = numberOfDays == 0 ? 100.0f : (float)(100 / numberOfDays);
        Iterator dayIterator = planner.getModel().dayIterator();
        while (dayIterator.hasNext()) {
            day = (Day)dayIterator.next();
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"header", null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.writeAttribute("style", (Object)"overflow: hidden; height: 31px;", null);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)planner);
        dayIterator = planner.getModel().dayIterator();
        while (dayIterator.hasNext()) {
            day = (Day)dayIterator.next();
            writer.startElement("td", (UIComponent)planner);
            writer.writeAttribute("class", (Object)"hours", null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.writeAttribute("style", (Object)"overflow: hidden; height: 15px; border-style: none; border-width: 0px", null);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EntryWrapper
    implements Comparable {
        private static final int HOUR = 3600000;
        private final Day day;
        private final PlannerEntity entity;
        private final ScheduleEntry entry;

        EntryWrapper(ScheduleEntry entry, Day day, PlannerEntity entity) {
            this.entry = entry;
            this.day = day;
            this.entity = entity;
        }

        public int compareTo(Object o) {
            return comparator.compare(this.entry, o);
        }

        public boolean equals(Object o) {
            if (o instanceof EntryWrapper) {
                EntryWrapper other = (EntryWrapper)o;
                boolean returnboolean = this.entry.getStartTime().equals(other.entry.getStartTime()) && this.entry.getEndTime().equals(other.entry.getEndTime()) && this.entry.getId().equals(other.entry.getId()) && this.day.equals(other.day);
                return returnboolean;
            }
            return false;
        }

        public int hashCode() {
            int returnint = this.entry.getStartTime().hashCode() ^ this.entry.getEndTime().hashCode() ^ this.entry.getId().hashCode();
            return returnint;
        }

        String getBounds(HtmlPlanner planner) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(this.day.getDate());
            int curyear = cal.get(1);
            int curmonth = cal.get(2);
            int curday = cal.get(5);
            cal.setTime(this.entry.getStartTime());
            cal.set(curyear, curmonth, curday);
            long startMillis = cal.getTimeInMillis();
            cal.set(11, planner.getVisibleStartHour());
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleStartMillis = cal.getTimeInMillis();
            startMillis = this.day.equalsDate(this.entry.getStartTime()) ? Math.max(startMillis, visibleStartMillis) : visibleStartMillis;
            cal.setTime(this.entry.getEndTime());
            cal.set(curyear, curmonth, curday);
            long endMillis = cal.getTimeInMillis();
            cal.set(11, planner.getVisibleEndHour());
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleEndMillis = cal.getTimeInMillis();
            endMillis = this.day.equalsDate(this.entry.getEndTime()) ? Math.min(endMillis, visibleEndMillis) : visibleEndMillis;
            float left = (float)((startMillis - visibleStartMillis) * 100L) / (float)(visibleEndMillis - visibleStartMillis);
            float width = (float)((endMillis - startMillis) * 100L) / (float)(visibleEndMillis - visibleStartMillis);
            StringBuffer buffer = new StringBuffer();
            buffer.append("position: absolute; padding: 0px; top: 0px; height: 21px; left: ");
            buffer.append(String.valueOf(left));
            buffer.append("%; width: ");
            buffer.append(String.valueOf(width));
            buffer.append("%; overflow: hidden; border-style-none; border-width: 0px;");
            return buffer.toString();
        }
    }
}

