/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.AbstractScheduleRenderer;

public class ScheduleDetailedDayRenderer
extends AbstractScheduleRenderer {
    private final int rowHeightInPixels = 22;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        super.encodeBegin(context, component);
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        int numberOfRows = (schedule.getVisibleEndHour() - schedule.getVisibleStartHour()) * 2 + 1;
        int gridHeight = numberOfRows * 22 + 3 + 10;
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"schedule-detailed", null);
        writer.writeAttribute("style", (Object)("height: " + String.valueOf(gridHeight) + "px; overflow: hidden;"), null);
        this.writeBackground(context, schedule, writer);
        this.writeForegroundStart(context, schedule, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"column", null);
            writer.writeAttribute("style", (Object)"height: 100%;", null);
            writer.startElement("div", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"column", null);
            writer.writeAttribute("style", (Object)"position: relative; top: 0px; left: 0px; width: 100%; height: 100%; z-index: 0;", null);
            this.writeEntries(context, schedule, day, writer);
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        this.writeForegroundEnd(context, schedule, writer);
        writer.endElement("div");
    }

    private String getCellClass(HtmlSchedule schedule, int column, int row) {
        String cellClass = "free";
        ScheduleDay day = (ScheduleDay)schedule.getModel().get(column);
        if (!day.isWorkingDay()) {
            return cellClass;
        }
        if (schedule.getVisibleStartHour() + row / 2 >= schedule.getWorkingStartHour() && schedule.getVisibleStartHour() + row / 2 < schedule.getWorkingEndHour()) {
            cellClass = row % 2 == 0 ? "even" : "uneven";
        }
        return cellClass;
    }

    private boolean isSelected(HtmlSchedule schedule, EntryWrapper entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        boolean returnboolean = selectedEntry.getId().equals(entry.entry.getId());
        return returnboolean;
    }

    private void maximizeEntries(EntryWrapper[] entries, int numberOfColumns) {
        for (int i = 0; i < entries.length; ++i) {
            EntryWrapper entry = entries[i];
            while (entry.column + entry.colspan < numberOfColumns && entry.canFitInColumn(entry.column + entry.colspan)) {
                entry.colspan++;
            }
        }
    }

    private void scanEntries(EntryWrapper[] entries, int index) {
        if (entries.length <= 0) {
            return;
        }
        EntryWrapper entry = entries[index];
        entry.column = 0;
        for (int i = 0; i < index; ++i) {
            if (!entry.overlaps(entries[i])) continue;
            entry.overlappingEntries.add(entries[i]);
            entries[i].overlappingEntries.add(entry);
        }
        while (!entry.canFitInColumn(entry.column)) {
            entry.column++;
        }
        if (++index < entries.length) {
            this.scanEntries(entries, index);
        }
    }

    private void writeBackground(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        UIForm parentForm = this.getParentForm((UIComponent)schedule);
        if (parentForm == null) {
            throw new NullPointerException("No parent UIForm found");
        }
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"background", null);
        writer.writeAttribute("style", (Object)"position: absolute;\tleft: 0px; top: 0px; width: 100%; height: 100%; z-index: 0;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"background", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tbody", (UIComponent)schedule);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"gutter", null);
        writer.writeAttribute("style", (Object)"height: 21px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px", null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"header", null);
            writer.writeAttribute("style", (Object)"height: 31px; border-style: none; border-width: 0px; overflow: hidden;", null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.startElement("div", (UIComponent)schedule);
            writer.writeAttribute("style", (Object)"position: relative; left: 0px; top: 0px; width: 100%; height: 100%;", null);
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"date", null);
            writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 0px; height: 15px; width: 100%; vertical-align: top; overflow: hidden; white-space: nowrap;", null);
            writer.writeText((Object)this.getDateString(context, (UIComponent)schedule, day.getDate()), null);
            writer.endElement("span");
            if (day.getSpecialDayName() != null && day.getSpecialDayName().length() > 0) {
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"holiday", null);
                writer.writeAttribute("style", (Object)"position: absolute; left: 0px; top: 15px; width: 100%; vertical-align: top; overflow: hidden; white-space: nowrap;", null);
                writer.writeText((Object)day.getSpecialDayName(), null);
                writer.endElement("span");
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        int numberOfRows = (schedule.getVisibleEndHour() - schedule.getVisibleStartHour()) * 2;
        for (int row = 0; row < numberOfRows; ++row) {
            writer.startElement("tr", (UIComponent)schedule);
            if (row % 2 == 0) {
                writer.startElement("td", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"gutter", null);
                writer.writeAttribute("style", (Object)"height: 21px; border-style: none; border-width: 0px; overflow: hidden; padding: 0px", null);
                writer.writeAttribute("rowspan", (Object)"2", null);
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"hours", null);
                writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                writer.writeText((Object)String.valueOf(schedule.getVisibleStartHour() + row / 2), null);
                writer.endElement("span");
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"minutes", null);
                writer.writeAttribute("style", (Object)"vertical-align: top; height: 100%; padding: 0px;", null);
                writer.writeText((Object)"00", null);
                writer.endElement("span");
                writer.endElement("td");
            }
            for (int column = 0; column < schedule.getModel().size(); ++column) {
                writer.startElement("td", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)this.getCellClass(schedule, column, row), null);
                writer.writeAttribute("style", (Object)"overflow: hidden; height: 21px;", null);
                writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
                writer.write("&#160;");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        TreeSet<EntryWrapper> entrySet = new TreeSet<EntryWrapper>();
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            entrySet.add(new EntryWrapper((ScheduleEntry)entryIterator.next(), day));
        }
        EntryWrapper[] entries = entrySet.toArray(new EntryWrapper[entrySet.size()]);
        this.scanEntries(entries, 0);
        int maxColumn = 0;
        Iterator entryIterator2 = entrySet.iterator();
        while (entryIterator2.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator2.next();
            maxColumn = Math.max(wrapper.column, maxColumn);
        }
        int numberOfColumns = maxColumn + 1;
        this.maximizeEntries(entries, numberOfColumns);
        float columnWidth = 100 / numberOfColumns;
        UIForm parentForm = this.getParentForm((UIComponent)schedule);
        Iterator entryIterator3 = entrySet.iterator();
        while (entryIterator3.hasNext()) {
            EntryWrapper wrapper = (EntryWrapper)entryIterator3.next();
            if (this.isSelected(schedule, wrapper)) {
                writer.startElement("div", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"entry-selected", null);
                writer.writeAttribute("style", (Object)wrapper.getBounds(schedule, columnWidth), null);
                if (this.showTooltip((UIComponent)schedule)) {
                    writer.writeAttribute("onmouseover", (Object)this.getTooltipText(wrapper.entry, (UIComponent)schedule), null);
                }
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"text", null);
                writer.writeAttribute("style", (Object)"height: 100%; width: 100%;", null);
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"title", null);
                writer.writeText((Object)wrapper.entry.getTitle(), null);
                writer.endElement("span");
                writer.startElement("br", (UIComponent)schedule);
                writer.endElement("br");
                writer.startElement("span", (UIComponent)schedule);
                writer.writeAttribute("class", (Object)"subtitle", null);
                writer.writeText((Object)wrapper.entry.getSubtitle(), null);
                writer.endElement("span");
                writer.endElement("div");
                writer.endElement("div");
                continue;
            }
            writer.startElement(schedule.isReadonly() ? "div" : "a", (UIComponent)schedule);
            if (this.showTooltip((UIComponent)schedule)) {
                writer.writeAttribute("onmouseover", (Object)this.getTooltipText(wrapper.entry, (UIComponent)schedule), null);
            }
            if (!schedule.isReadonly()) {
                writer.writeAttribute("href", (Object)"#", null);
                String clientId = schedule.getClientId(context);
                StringBuffer mousedown = new StringBuffer();
                mousedown.append("document.forms['");
                mousedown.append(parentForm.getClientId(context));
                mousedown.append("']['");
                mousedown.append(clientId);
                mousedown.append("'].value='");
                mousedown.append(wrapper.entry.getId());
                mousedown.append("'; document.forms['");
                mousedown.append(parentForm.getClientId(context));
                mousedown.append("'].submit()");
                writer.writeAttribute("onmousedown", (Object)mousedown.toString(), null);
            }
            writer.writeAttribute("class", (Object)"entry", null);
            writer.writeAttribute("style", (Object)wrapper.getBounds(schedule, columnWidth), null);
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"title", null);
            writer.writeText((Object)wrapper.entry.getTitle(), null);
            writer.endElement("span");
            writer.startElement("br", (UIComponent)schedule);
            writer.endElement("br");
            writer.startElement("span", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"subtitle", null);
            writer.writeText((Object)wrapper.entry.getSubtitle(), null);
            writer.endElement("span");
            writer.endElement(schedule.isReadonly() ? "div" : "a");
        }
    }

    private void writeForegroundEnd(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeForegroundStart(FacesContext context, HtmlSchedule schedule, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"foreground", null);
        writer.writeAttribute("style", (Object)"position: absolute;\tleft: 0px; top: 0px; width: 100%; height: 100%;\tz-index: 2;", null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)"foreground", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%", null);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
        float columnWidth = schedule.getModel().size() == 0 ? 100.0f : (float)(100 / schedule.getModel().size());
        Iterator dayIterator = schedule.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            writer.startElement("td", (UIComponent)schedule);
            writer.writeAttribute("class", (Object)"header", null);
            writer.writeAttribute("style", (Object)"height: 31px; border-style: none; border-width: 0px; overflow: hidden;", null);
            writer.writeAttribute("width", (Object)(String.valueOf(columnWidth) + "%"), null);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"height: 1px; width: 56px", null);
        writer.endElement("div");
        writer.endElement("td");
    }

    private class EntryWrapper
    implements Comparable {
        private static final int HALF_HOUR = 1800000;
        private final ScheduleDay day;
        private final ScheduleEntry entry;
        private final TreeSet overlappingEntries;
        private int colspan;
        private int column;

        EntryWrapper(ScheduleEntry entry, ScheduleDay day) {
            this.entry = entry;
            this.day = day;
            this.column = 0;
            this.colspan = 1;
            this.overlappingEntries = new TreeSet();
        }

        public int compareTo(Object o) {
            return AbstractScheduleRenderer.comparator.compare(this.entry, o);
        }

        public boolean equals(Object o) {
            if (o instanceof EntryWrapper) {
                EntryWrapper other = (EntryWrapper)o;
                boolean returnboolean = this.entry.getStartTime().equals(other.entry.getStartTime()) && this.entry.getEndTime().equals(other.entry.getEndTime()) && this.entry.getId().equals(other.entry.getId()) && this.day.equals(other.day);
                return returnboolean;
            }
            return false;
        }

        public int hashCode() {
            int returnint = this.entry.getStartTime().hashCode() ^ this.entry.getEndTime().hashCode() ^ this.entry.getId().hashCode();
            return returnint;
        }

        String getBounds(HtmlSchedule schedule, float columnWidth) {
            float width = columnWidth * (float)this.colspan - 0.5f;
            float left = (float)this.column * columnWidth;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(this.day.getDate());
            int curyear = cal.get(1);
            int curmonth = cal.get(2);
            int curday = cal.get(5);
            cal.setTime(this.entry.getStartTime());
            cal.set(curyear, curmonth, curday);
            long startMillis = cal.getTimeInMillis();
            cal.set(11, schedule.getVisibleStartHour());
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleStartMillis = cal.getTimeInMillis();
            startMillis = this.day.equalsDate(this.entry.getStartTime()) ? Math.max(startMillis, visibleStartMillis) : visibleStartMillis;
            cal.setTime(this.entry.getEndTime());
            cal.set(curyear, curmonth, curday);
            long endMillis = cal.getTimeInMillis();
            cal.set(11, schedule.getVisibleEndHour());
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long visibleEndMillis = cal.getTimeInMillis();
            endMillis = this.day.equalsDate(this.entry.getEndTime()) ? Math.min(endMillis, visibleEndMillis) : visibleEndMillis;
            int top = (int)((startMillis - visibleStartMillis) * 22L / 1800000L);
            int height = (int)((endMillis - startMillis) * 22L / 1800000L);
            StringBuffer buffer = new StringBuffer();
            buffer.append("position: absolute; height: ");
            buffer.append(height);
            buffer.append("px; top: ");
            buffer.append(top);
            buffer.append("px; left: ");
            buffer.append(left);
            buffer.append("%; width: ");
            buffer.append(width);
            buffer.append("%; padding: 0px; overflow: hidden; border-width: 1.0px; border-style:solid;");
            return buffer.toString();
        }

        boolean canFitInColumn(int column) {
            Iterator overlapIterator = this.overlappingEntries.iterator();
            while (overlapIterator.hasNext()) {
                EntryWrapper overlap = (EntryWrapper)overlapIterator.next();
                if (overlap.column != column) continue;
                return false;
            }
            return true;
        }

        boolean overlaps(EntryWrapper other) {
            if (this.entry.getStartTime() == null || this.entry.getEndTime() == null) {
                return false;
            }
            boolean returnboolean = this.entry.getStartTime().before(other.entry.getEndTime()) && this.entry.getEndTime().after(other.entry.getStartTime());
            return returnboolean;
        }
    }
}

