/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class ScheduleUtil {
    public static boolean isBindingExpression(Object value) {
        boolean returnboolean = value != null && value instanceof String && ((String)value).startsWith("#{") && ((String)value).endsWith("}");
        return returnboolean;
    }

    public static boolean getBooleanProperty(UIComponent component, Boolean property, String key, boolean defaultValue) {
        Boolean value;
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(Object attributeValue, boolean valueIfNull) {
        if (attributeValue == null) {
            return valueIfNull;
        }
        if (attributeValue instanceof String) {
            return ((String)attributeValue).equalsIgnoreCase("true");
        }
        return (Boolean)attributeValue;
    }

    public static float getFloatProperty(UIComponent component, Float property, String key, float defaultValue) {
        Float value;
        if (property != null) {
            return property.floatValue();
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Float)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value.floatValue();
        }
        return defaultValue;
    }

    public static int getHashCodeForDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Integer(calendar.get(0)).hashCode() ^ new Integer(calendar.get(1)).hashCode() ^ new Integer(calendar.get(6)).hashCode();
    }

    public static int getIntegerProperty(UIComponent component, Integer property, String key, int defaultValue) {
        Integer value;
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Integer)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        return defaultValue;
    }

    public static Object getObjectProperty(UIComponent component, Object property, String key, Object defaultValue) {
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null) {
            return binding.getValue(FacesContext.getCurrentInstance());
        }
        return defaultValue;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(0) == calendar2.get(0) && calendar1.get(1) == calendar2.get(1) && calendar1.get(6) == calendar2.get(6);
    }

    public static String getStringProperty(UIComponent component, String property, String key, String defaultValue) {
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null) {
            return (String)binding.getValue(FacesContext.getCurrentInstance());
        }
        return defaultValue;
    }

    public static boolean canModifyValue(UIComponent component) {
        boolean returnboolean = component.isRendered() && !ScheduleUtil.getBooleanValue(component.getAttributes().get("readonly"), false) && !ScheduleUtil.getBooleanValue(component.getAttributes().get("disabled"), false);
        return returnboolean;
    }

    public static int compareDays(Date date1, Date date2) {
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return ScheduleUtil.truncate(date1).compareTo(ScheduleUtil.truncate(date2));
    }

    public static Date truncate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

