/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.JSFTagDefinition;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;
import tk.eclipse.plugin.jsf.Util;

public class JSFAttributeAssist
implements ICustomTagAttributeAssist {
    private Image classImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_class");
    private Image fieldImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_field");
    private Image methodImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_method");
    public static final String[] IMPLICIT_OBJECTS = new String[]{"applicationScope", "cookie", "facesContext", "header", "headerValues", "initParam", "param", "paramValues", "requestScope", "sessionScope"};

    public AssistInfo[] getAttributeValues(String tagName, String uri, String value, AttributeInfo attrInfo) {
        try {
            if (!(uri.equals("http://java.sun.com/jsf/html") || uri.equals("http://java.sun.com/jsf/core") || uri.equals("http://myfaces.sourceforge.net/tld/myfaces_ext_0_9.tld"))) {
                return null;
            }
            if (!this.getFile().getProject().hasNature("tk.eclipse.plugin.jsf.JSFProjectNature")) {
                return null;
            }
            String attrName = attrInfo.getAttributeName();
            if (value.startsWith("#{")) {
                String type = JSFTagDefinition.getAttributeInfo(tagName, attrName);
                if (type == null) {
                    return null;
                }
                value = value.replaceFirst("^#\\{", "");
                String lastWord = value = value.replaceFirst("\\}$", "");
                String preWord = "";
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < value.length()) {
                    char c = value.charAt(i);
                    if (Character.isJavaIdentifierPart(c) || c == '.') {
                        sb.append(c);
                    } else {
                        sb.setLength(0);
                    }
                    ++i;
                }
                lastWord = sb.toString();
                preWord = value.substring(0, value.length() - lastWord.length());
                if (lastWord.indexOf(".") == -1) {
                    ManagedBean[] beans = this.getProject().getManagedBeans();
                    AssistInfo[] assists = new AssistInfo[beans.length + IMPLICIT_OBJECTS.length];
                    int i2 = 0;
                    while (i2 < beans.length) {
                        assists[i2] = new AssistInfo("#{" + preWord + beans[i2].getBeanName(), String.valueOf(beans[i2].getBeanName()) + " - " + beans[i2].getClassName(), this.classImage);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < IMPLICIT_OBJECTS.length) {
                        assists[i2 + beans.length] = new AssistInfo("#{" + preWord + IMPLICIT_OBJECTS[i2], String.valueOf(IMPLICIT_OBJECTS[i2]) + " - " + JSFPlugin.getResourceString("ContentAssistProposal.implicitObject"), this.classImage);
                        ++i2;
                    }
                    return assists;
                }
                String[] dim = Util.splitManagedBean(lastWord);
                preWord = String.valueOf(preWord) + Util.joinManagedBean(dim);
                ManagedBean bean = Util.evalPropertyBinding(dim, this.getProject());
                if (bean != null) {
                    return this.getManagedBeanProperties(bean, type, preWord);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private AssistInfo[] getManagedBeanProperties(ManagedBean bean, String type, String pre) {
        if (type == "prop" || type == "value") {
            ManagedBeanProperty[] beanProps = bean.getProperties();
            AssistInfo[] info = new AssistInfo[beanProps.length];
            int j = 0;
            while (j < beanProps.length) {
                info[j] = new AssistInfo("#{" + pre + "." + beanProps[j].getPropertyName(), String.valueOf(beanProps[j].getPropertyName()) + " - " + beanProps[j].getPropertyType(), this.fieldImage);
                ++j;
            }
            return info;
        }
        try {
            ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
            ManagedBeanProperty[] beanProps = bean.getProperties();
            int j = 0;
            while (j < beanProps.length) {
                AssistInfo info = new AssistInfo("#{" + pre + "." + beanProps[j].getPropertyName(), String.valueOf(beanProps[j].getPropertyName()) + " - " + beanProps[j].getPropertyType(), this.fieldImage);
                list.add(info);
                ++j;
            }
            String[] methods = new String[]{};
            if (type == "action") {
                methods = bean.getActionMethodNames();
            } else if (type == "actionListener") {
                methods = bean.getActionListenerMethodNames();
            } else if (type == "valudaChangeListener") {
                methods = bean.getValueChangeListenerMethodNames();
            } else if (type == "validater") {
                methods = bean.getValidaterMethodNames();
            }
            int i = 0;
            while (i < methods.length) {
                AssistInfo info = new AssistInfo("#{" + pre + "." + methods[i], methods[i], this.methodImage);
                list.add(info);
                ++i;
            }
            return list.toArray(new AssistInfo[list.size()]);
        }
        catch (Exception exception) {
            return new AssistInfo[0];
        }
    }

    private JSFProject getProject() {
        IProject project = this.getFile().getProject();
        return new JSFProject(JavaCore.create((IProject)project));
    }

    private IFile getFile() {
        IEditorPart editor = Util.getActiveEditor();
        return ((IFileEditorInput)editor.getEditorInput()).getFile();
    }
}

