/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.io.InputStream;
import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.IManagedBeanProvider;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;

public class JSFProject {
    private IJavaProject project;
    private HTMLProjectParams params;

    public JSFProject(IJavaProject project) {
        this.project = project;
        try {
            this.params = new HTMLProjectParams(project.getProject());
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    public ManagedBean[] getManagedBeans() {
        try {
            IFile[] files = this.getFacesConfigXML();
            ArrayList<ManagedBean> list = new ArrayList<ManagedBean>();
            int j = 0;
            while (j < files.length) {
                InputStream in = files[j].getContents();
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(new String(FuzzyXMLUtil.readStream((InputStream)in)));
                in.close();
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/managed-bean");
                int i = 0;
                while (i < nodes.length) {
                    String name = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-name");
                    String clazz = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-class");
                    String scope = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-scope");
                    if (name != null && !name.equals("") && clazz != null && !clazz.equals("")) {
                        list.add(new ManagedBean(this.project, clazz, name, scope));
                    }
                    ++i;
                }
                ++j;
            }
            IManagedBeanProvider[] contributedProviders = JSFPlugin.getDefault().getManagedBeanProviders();
            int i = 0;
            while (i < contributedProviders.length) {
                ManagedBean[] beans = contributedProviders[i].getManagedBean(this.project, this.params.getRoot());
                int j2 = 0;
                while (j2 < beans.length) {
                    list.add(beans[j2]);
                    ++j2;
                }
                ++i;
            }
            return list.toArray(new ManagedBean[list.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ManagedBean[0];
        }
    }

    public ManagedBean getManagedBean(String beanName) {
        ManagedBean[] beans = this.getManagedBeans();
        int i = 0;
        while (i < beans.length) {
            if (beans[i].getBeanName().equals(beanName)) {
                return beans[i];
            }
            ++i;
        }
        return null;
    }

    public IFile[] getFacesConfigXML() {
        String root = this.params.getRoot();
        try {
            FuzzyXMLDocument doc;
            String value;
            IPath path = new Path(root).append("/WEB-INF/web.xml");
            IFile file = this.project.getProject().getFile(path);
            if (file != null && file.exists() && (value = HTMLUtil.getXPathValue((FuzzyXMLElement)(doc = new FuzzyXMLParser().parse(file.getContents())).getDocumentElement(), (String)"/web-app/context-param[param-name='javax.faces.CONFIG_FILES']/param-value")) != null) {
                String[] names = value.split(",");
                ArrayList<IFile> files = new ArrayList<IFile>();
                int i = 0;
                while (i < names.length) {
                    path = new Path(root).append(names[i].trim());
                    file = this.project.getProject().getFile(path);
                    if (file != null && file.exists()) {
                        files.add(file);
                    }
                    ++i;
                }
                return files.toArray(new IFile[files.size()]);
            }
            path = new Path(root).append("/WEB-INF/faces-config.xml");
            file = this.project.getProject().getFile(path);
            if (file != null && file.exists()) {
                return new IFile[]{file};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new IFile[0];
    }
}

