/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import java.util.ArrayList;
import java.util.ResourceBundle;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.FacesConfigXMLEditor;
import tk.eclipse.plugin.jsf.editors.ManagedBeanEditor;
import tk.eclipse.plugin.jsf.editors.NavigationEditor;

public class MultiPageFacesConfigEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private NavigationEditor navigationEditor;
    private FacesConfigXMLEditor sourceEditor;
    private ManagedBeanEditor managedBeanEditor;
    private FacesConfigOperation operation;
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
    public static final int INDEX_NAVIGATION_EDITOR = 0;
    public static final int INDEX_MANAGED_BEAN_EDITOR = 1;
    public static final int INDEX_SOURCE_EDITOR = 2;
    boolean firstFlag = true;
    static /* synthetic */ Class class$0;

    public MultiPageFacesConfigEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.operation = new FacesConfigOperation(this, new SynchronizeSourceEditorListener());
    }

    private void createPage0() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.navigationEditor = new NavigationEditor(this.operation);
                int index = this.addPage((IEditorPart)this.navigationEditor, this.getEditorInput());
                this.setPageText(index, this.resource.getString("editor.tab.flow"));
            }
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage1() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.managedBeanEditor = new ManagedBeanEditor(this.operation);
                int index = this.addPage((IEditorPart)this.managedBeanEditor, this.getEditorInput());
                this.setPageText(index, this.resource.getString("editor.tab.managedbean"));
            }
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage2() {
        try {
            this.sourceEditor = new FacesConfigXMLEditor();
            int index = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(index, this.resource.getString("editor.tab.source"));
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.createPage2();
        this.syncEditors(0);
        this.syncEditors(1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        int page = this.getActivePage();
        if (page == 2) {
            this.syncEditors(0);
            this.syncEditors(1);
        }
        this.sourceEditor.doSave(monitor);
        this.managedBeanEditor.doSave(monitor);
        this.navigationEditor.doSave();
    }

    public void doSaveAs() {
        int page = this.getActivePage();
        if (page == 2) {
            this.syncEditors(0);
            this.syncEditors(1);
        }
        this.sourceEditor.doSaveAs();
        this.managedBeanEditor.doSaveAs();
        this.setInput(this.sourceEditor.getEditorInput());
        this.navigationEditor.doSave(this.sourceEditor.getEditorInput());
        this.setPartName(this.sourceEditor.getEditorInput().getName());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor instanceof FacesConfigXMLEditor) {
            return new SourceEditorSite(this, editor, this.getEditorSite());
        }
        return super.createSite(editor);
    }

    protected void pageChange(int newPageIndex) {
        if (this.isDirty()) {
            this.syncEditors(newPageIndex);
            this.sourceEditor.updateEditor();
        }
        super.pageChange(newPageIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncEditors(int page) {
        try {
            if (!this.sourceEditor.isFileEditorInput()) {
                Object var2_2 = null;
                this.operation.setAllowOperation(true);
                return;
            }
            this.operation.setAllowOperation(false);
            if (page == 0) {
                this.navigationEditor.update(this.getDocument().get());
            } else if (page == 1) {
                this.managedBeanEditor.update(this.getDocument().get());
            }
            Object var2_4 = null;
            this.operation.setAllowOperation(true);
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.operation.setAllowOperation(true);
            throw throwable;
        }
    }

    public IDocument getDocument() {
        IEditorInput input = this.sourceEditor.getEditorInput();
        IDocument doc = this.sourceEditor.getDocumentProvider().getDocument((Object)input);
        return doc;
    }

    public void setFocus() {
        if (this.firstFlag) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firstFlag = false;
        }
        super.setFocus();
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MultiPageFacesConfigEditor.this.navigationEditor.updateIconStatus();
            }
        });
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MultiPageFacesConfigEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)MultiPageFacesConfigEditor.this.navigationEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MultiPageFacesConfigEditor.this.navigationEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            this.setActivePage(2);
            return this.sourceEditor.getAdapter(adapter);
        }
        return this.navigationEditor.getAdapter(adapter);
    }

    private class SynchronizeSourceEditorListener
    implements FuzzyXMLModifyListener {
        SynchronizeSourceEditorListener() {
        }

        public void modified(FuzzyXMLModifyEvent evt) {
            try {
                IEditorInput input = MultiPageFacesConfigEditor.this.sourceEditor.getEditorInput();
                IDocument doc = MultiPageFacesConfigEditor.this.sourceEditor.getDocumentProvider().getDocument((Object)input);
                doc.replace(evt.getOffset(), evt.getLength(), evt.getNewText());
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
        }
    }

    private class SourceEditorSite
    extends MultiPageEditorSite {
        private HTMLSourceEditor editor = null;
        private IEditorSite site;
        private ArrayList menuExtenders;

        public SourceEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor, IEditorSite site) {
            super(multiPageEditor, editor);
            this.site = site;
            this.editor = (HTMLSourceEditor)editor;
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this.site.getActionBarContributor();
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            if (this.editor != null) {
                if (this.menuExtenders == null) {
                    this.menuExtenders = new ArrayList(1);
                }
                this.menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, (IWorkbenchPart)this.editor));
            }
        }

        public void dispose() {
            if (this.menuExtenders != null) {
                int i = 0;
                while (i < this.menuExtenders.size()) {
                    ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                    ++i;
                }
                this.menuExtenders = null;
            }
            super.dispose();
        }
    }
}

