/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractNavigationConnectionEditPart;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;

public class ForwardEditPart
extends AbstractNavigationConnectionEditPart {
    private FacesConfigOperation operation;
    private ForwardDirectEditManager directManager;

    public ForwardEditPart(FacesConfigOperation operation) {
        this.operation = operation;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ForwardDirectEditPolicy());
    }

    protected IFigure createFigure() {
        ForwardModel model = (ForwardModel)this.getModel();
        String name = "<navigation-case>";
        if (!model.getFromAction().equals("")) {
            name = model.getFromAction();
        } else if (!model.getFromOutcome().equals("")) {
            name = model.getFromOutcome();
        }
        LabelConnection connection = new LabelConnection();
        connection.setText(name);
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (model.getSource() == model.getTarget() && ((AbstractConnectionModel)this.getModel()).getBendpoints().size() == 0) {
            AbstractEntityModel source = model.getSource();
            Rectangle constraint = source.getConstraint();
            model.addBendpoint(0, new Point(constraint.x, constraint.y - 20));
            model.addBendpoint(1, new Point(constraint.x - 20, constraint.y - 20));
            model.addBendpoint(2, new Point(constraint.x - 20, constraint.y));
        }
        return connection;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        ForwardModel model = (ForwardModel)this.getModel();
        String name = (String)evt.getNewValue();
        String fromViewId = ((PageModel)model.getSource()).getPath();
        String toViewId = ((PageModel)model.getTarget()).getPath();
        String action = model.getFromAction();
        String outcome = model.getFromOutcome();
        this.operation.updateNavigation(fromViewId, toViewId, outcome, action);
        if (propName.equals("__bend_point")) {
            this.refreshBendpoints();
            return;
        }
        if (propName.equals("__from_action")) {
            if (name.equals("")) {
                name = model.getFromOutcome().equals("") ? "<navigation-case>" : model.getFromOutcome();
            }
        } else if (propName.equals("__from_outcome")) {
            if (name.equals("")) {
                name = model.getFromAction().equals("") ? "<navigation-case>" : model.getFromAction();
            }
        } else {
            return;
        }
        LabelConnection connection = (LabelConnection)this.getFigure();
        connection.setText(name);
        this.refreshVisuals();
    }

    protected void refreshBendpoints() {
        List bendpoints = ((AbstractConnectionModel)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint((Point)bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new ForwardDirectEditManager();
        }
        this.directManager.show();
    }

    private class LabelConnection
    extends PolylineConnection {
        private Label label = new Label();

        public LabelConnection() {
            this.add((IFigure)this.label, new ConnectionLocator((Connection)this, 4));
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        }

        public void setText(String text) {
            this.label.setText(text);
        }
    }

    private class ForwardDirectEditManager
    extends DirectEditManager {
        ForwardEditDialog dialog = null;

        public ForwardDirectEditManager() {
            super((GraphicalEditPart)ForwardEditPart.this, null, null);
        }

        public void show() {
            if (this.dialog == null) {
                this.dialog = new ForwardEditDialog(null);
            }
            if (this.dialog.open() == 0) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                stack.execute(this.getEditPart().getCommand((Request)this.getDirectEditRequest()));
            }
        }

        protected void initCellEditor() {
        }

        protected DirectEditRequest createDirectEditRequest() {
            DirectEditRequest req = new DirectEditRequest();
            req.setDirectEditFeature((Object)this.dialog);
            return req;
        }
    }

    private class ForwardEditDialog
    extends Dialog {
        private Text fromOutcome;
        private Text fromAction;
        private String resultFromOutcome;
        private String resultFromAction;

        public ForwardEditDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void constrainShellSize() {
            this.getShell().setSize(350, this.getShell().getSize().y);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("navigation-case");
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(768));
            org.eclipse.swt.widgets.Label label = null;
            label = new org.eclipse.swt.widgets.Label(composite, 0);
            label.setText("from-action");
            this.fromAction = new Text(composite, 2048);
            this.fromAction.setLayoutData((Object)new GridData(768));
            this.fromAction.setText(model.getFromAction());
            label = new org.eclipse.swt.widgets.Label(composite, 0);
            label.setText("from-outcome");
            this.fromOutcome = new Text(composite, 2048);
            this.fromOutcome.setLayoutData((Object)new GridData(768));
            this.fromOutcome.setText(model.getFromOutcome());
            return composite;
        }

        public String getFromAction() {
            return this.resultFromAction;
        }

        public String getFromOutcome() {
            return this.resultFromOutcome;
        }

        protected void okPressed() {
            this.resultFromAction = this.fromAction.getText();
            this.resultFromOutcome = this.fromOutcome.getText();
            super.okPressed();
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldFromAction;
        private String oldFromOutcome;
        private String newFromAction;
        private String newFromOutcome;

        DirectEditCommand() {
        }

        public void execute() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            this.oldFromAction = model.getFromAction();
            this.oldFromOutcome = model.getFromOutcome();
            model.setFromAction(this.newFromAction);
            model.setFromOutcome(this.newFromOutcome);
        }

        public void setFromOutcome(String fromOutcome) {
            this.newFromOutcome = fromOutcome;
        }

        public void setFromAction(String fromACtion) {
            this.newFromAction = fromACtion;
        }

        public void undo() {
            ForwardModel model = (ForwardModel)ForwardEditPart.this.getModel();
            model.setFromAction(this.oldFromAction);
            model.setFromOutcome(this.oldFromOutcome);
        }
    }

    private class ForwardDirectEditPolicy
    extends DirectEditPolicy {
        ForwardDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            ForwardEditDialog dialog = (ForwardEditDialog)((Object)request.getDirectEditFeature());
            command.setFromAction(dialog.getFromAction());
            command.setFromOutcome(dialog.getFromOutcome());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

