/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;

public class HtmlDataList
extends HtmlDataTableHack {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataList";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.List";
    private String _layout = null;
    private String _rowIndexVar = null;
    private String _rowCountVar = null;
    private String _onclick = null;
    private String _ondblclick = null;
    private String _onkeydown = null;
    private String _onkeypress = null;
    private String _onkeyup = null;
    private String _onmousedown = null;
    private String _onmousemove = null;
    private String _onmouseout = null;
    private String _onmouseover = null;
    private String _onmouseup = null;
    private String _style = null;
    private String _styleClass = null;
    private String _title = null;

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            return super.getClientId(context);
        }
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + "_" + rowIndex;
    }

    public void processDecodes(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                child.processDecodes(context);
            }
        }
        this.setRowIndex(-1);
        super.processDecodes(context);
    }

    public void processUpdates(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                child.processUpdates(context);
            }
        }
        this.setRowIndex(-1);
        super.processUpdates(context);
    }

    public void processValidators(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                child.processValidators(context);
            }
        }
        this.setRowIndex(-1);
        super.processValidators(context);
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        if (rowIndexVar != null || rowCountVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(this.getRowIndexVar(), new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(this.getRowCountVar(), new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(this.getRowIndexVar());
                }
                if (rowCountVar != null) {
                    requestMap.remove(this.getRowCountVar());
                }
            }
        }
    }

    public HtmlDataList() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setLayout(String layout) {
        this._layout = layout;
    }

    public String getLayout() {
        if (this._layout != null) {
            return this._layout;
        }
        ValueBinding vb = this.getValueBinding("layout");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowIndexVar(String rowIndexVar) {
        this._rowIndexVar = rowIndexVar;
    }

    public String getRowIndexVar() {
        if (this._rowIndexVar != null) {
            return this._rowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("rowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowCountVar(String rowCountVar) {
        this._rowCountVar = rowCountVar;
    }

    public String getRowCountVar() {
        if (this._rowCountVar != null) {
            return this._rowCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnclick(String onclick) {
        this._onclick = onclick;
    }

    public String getOnclick() {
        if (this._onclick != null) {
            return this._onclick;
        }
        ValueBinding vb = this.getValueBinding("onclick");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOndblclick(String ondblclick) {
        this._ondblclick = ondblclick;
    }

    public String getOndblclick() {
        if (this._ondblclick != null) {
            return this._ondblclick;
        }
        ValueBinding vb = this.getValueBinding("ondblclick");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnkeydown(String onkeydown) {
        this._onkeydown = onkeydown;
    }

    public String getOnkeydown() {
        if (this._onkeydown != null) {
            return this._onkeydown;
        }
        ValueBinding vb = this.getValueBinding("onkeydown");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnkeypress(String onkeypress) {
        this._onkeypress = onkeypress;
    }

    public String getOnkeypress() {
        if (this._onkeypress != null) {
            return this._onkeypress;
        }
        ValueBinding vb = this.getValueBinding("onkeypress");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnkeyup(String onkeyup) {
        this._onkeyup = onkeyup;
    }

    public String getOnkeyup() {
        if (this._onkeyup != null) {
            return this._onkeyup;
        }
        ValueBinding vb = this.getValueBinding("onkeyup");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnmousedown(String onmousedown) {
        this._onmousedown = onmousedown;
    }

    public String getOnmousedown() {
        if (this._onmousedown != null) {
            return this._onmousedown;
        }
        ValueBinding vb = this.getValueBinding("onmousedown");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnmousemove(String onmousemove) {
        this._onmousemove = onmousemove;
    }

    public String getOnmousemove() {
        if (this._onmousemove != null) {
            return this._onmousemove;
        }
        ValueBinding vb = this.getValueBinding("onmousemove");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnmouseout(String onmouseout) {
        this._onmouseout = onmouseout;
    }

    public String getOnmouseout() {
        if (this._onmouseout != null) {
            return this._onmouseout;
        }
        ValueBinding vb = this.getValueBinding("onmouseout");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnmouseover(String onmouseover) {
        this._onmouseover = onmouseover;
    }

    public String getOnmouseover() {
        if (this._onmouseover != null) {
            return this._onmouseover;
        }
        ValueBinding vb = this.getValueBinding("onmouseover");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnmouseup(String onmouseup) {
        this._onmouseup = onmouseup;
    }

    public String getOnmouseup() {
        if (this._onmouseup != null) {
            return this._onmouseup;
        }
        ValueBinding vb = this.getValueBinding("onmouseup");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyle(String style) {
        this._style = style;
    }

    public String getStyle() {
        if (this._style != null) {
            return this._style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public String getStyleClass() {
        if (this._styleClass != null) {
            return this._styleClass;
        }
        ValueBinding vb = this.getValueBinding("styleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        ValueBinding vb = this.getValueBinding("title");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._layout, this._rowIndexVar, this._rowCountVar, this._onclick, this._ondblclick, this._onkeydown, this._onkeypress, this._onkeyup, this._onmousedown, this._onmousemove, this._onmouseout, this._onmouseover, this._onmouseup, this._style, this._styleClass, this._title};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._layout = (String)values[1];
        this._rowIndexVar = (String)values[2];
        this._rowCountVar = (String)values[3];
        this._onclick = (String)values[4];
        this._ondblclick = (String)values[5];
        this._onkeydown = (String)values[6];
        this._onkeypress = (String)values[7];
        this._onkeyup = (String)values[8];
        this._onmousedown = (String)values[9];
        this._onmousemove = (String)values[10];
        this._onmouseout = (String)values[11];
        this._onmouseover = (String)values[12];
        this._onmouseup = (String)values[13];
        this._style = (String)values[14];
        this._styleClass = (String)values[15];
        this._title = (String)values[16];
    }
}

