/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navmenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.navmenu.NavigationMenuItem;
import org.apache.myfaces.custom.navmenu.UINavigationMenuItem;

public class NavigationMenuUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$navmenu$NavigationMenuUtils == null ? (class$org$apache$myfaces$custom$navmenu$NavigationMenuUtils = NavigationMenuUtils.class$("org.apache.myfaces.custom.navmenu.NavigationMenuUtils")) : class$org$apache$myfaces$custom$navmenu$NavigationMenuUtils));
    static /* synthetic */ Class class$org$apache$myfaces$custom$navmenu$NavigationMenuUtils;

    public static List getNavigationMenuItemList(UIComponent uiComponent) {
        ArrayList<NavigationMenuItem> list = new ArrayList<NavigationMenuItem>(uiComponent.getChildCount());
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (child instanceof UINavigationMenuItem) {
                NavigationMenuItem item;
                Object value = ((UINavigationMenuItem)child).getValue();
                if (value != null) {
                    if (!(value instanceof NavigationMenuItem)) {
                        FacesContext facesContext = FacesContext.getCurrentInstance();
                        throw new IllegalArgumentException("Value binding of UINavigationMenuItem with id " + child.getClientId(facesContext) + " does not reference an Object of type NavigationMenuItem");
                    }
                    item = (NavigationMenuItem)((Object)value);
                } else {
                    UINavigationMenuItem uiItem = (UINavigationMenuItem)child;
                    String label = uiItem.getItemLabel();
                    if (label == null && uiItem.getItemValue() != null) {
                        label = uiItem.getItemValue().toString();
                    }
                    item = new NavigationMenuItem(uiItem.getItemValue(), label, uiItem.getItemDescription(), uiItem.isItemDisabled() || !UserRoleUtils.isEnabledOnUserRole((UIComponent)uiItem), uiItem.isRendered(), uiItem.getAction(), uiItem.getIcon(), uiItem.isSplit());
                }
                list.add(item);
                if (child.getChildCount() <= 0) continue;
                List l = NavigationMenuUtils.getNavigationMenuItemList(child);
                item.setNavigationMenuItems(l.toArray(new NavigationMenuItem[l.size()]));
                continue;
            }
            if (child instanceof UISelectItems) {
                NavigationMenuUtils.addNavigationMenuItems((UISelectItems)child, list);
                continue;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            log.error((Object)("Invalid child with id " + child.getClientId(facesContext) + "of component with id : " + uiComponent.getClientId(facesContext) + " : must be UINavigationMenuItem or UINavigationMenuItems, is of type : " + (child == null ? "null" : child.getClass().getName())));
        }
        return list;
    }

    public static void addNavigationMenuItems(UISelectItems child, List list) {
        Object value = child.getValue();
        if (value instanceof NavigationMenuItem) {
            list.add(value);
        } else if (value instanceof NavigationMenuItem[]) {
            for (int i = 0; i < ((NavigationMenuItem[])value).length; ++i) {
                list.add(((NavigationMenuItem[])value)[i]);
            }
        } else if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof NavigationMenuItem)) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    throw new IllegalArgumentException("Collection referenced by UINavigationMenuItems with id " + child.getClientId(facesContext) + " does not contain Objects of type NavigationMenuItem");
                }
                list.add(item);
            }
        } else {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            throw new IllegalArgumentException("Value binding of UINavigationMenuItems with id " + child.getClientId(facesContext) + " does not reference an Object of type NavigationMenuItem, NavigationMenuItem[], Collection or Map");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

