/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.tree.HtmlTreeImageCommandLink;
import org.apache.myfaces.custom.tree.HtmlTreeNode;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlLinkRendererBase;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlTreeImageCommandLinkRenderer
extends HtmlLinkRendererBase {
    private static final Integer ZERO = new Integer(0);

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(HtmlRendererUtils.getFormName(component, facesContext)));
        if (reqValue != null && reqValue.equals(clientId)) {
            HtmlTreeNode node = (HtmlTreeNode)component.getParent();
            node.toggleExpanded();
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        super.renderCommandLinkStart(facesContext, component, clientId, value, style, styleClass);
        String url = ((HtmlTreeImageCommandLink)component).getImage();
        if (url != null && url.length() > 0) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("img", component);
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
            writer.writeAttribute("src", (Object)src, null);
            writer.writeAttribute("border", (Object)ZERO, null);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
            writer.endElement("img");
        }
    }
}

