/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputTextHelp;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.custom.inputTextHelp.HtmlInputTextHelp;
import org.apache.myfaces.renderkit.html.ext.HtmlTextRenderer;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlTextHelpRenderer
extends HtmlTextRenderer {
    private static final String JAVASCRIPT_ENCODED = "org.apache.myfaces.inputTextHelp.JAVASCRIPT_ENCODED";
    static /* synthetic */ Class class$org$apache$myfaces$custom$inputTextHelp$HtmlTextHelpRenderer;

    protected void renderNormal(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlInputTextHelp) {
            HtmlInputTextHelp helpTextComp = (HtmlInputTextHelp)component;
            HtmlTextHelpRenderer.addJavaScriptResources(facesContext);
            this.renderInputTextHelp(facesContext, (UIInput)helpTextComp);
        } else {
            super.renderNormal(facesContext, component);
        }
    }

    public static boolean isSelectText(UIComponent component) {
        if (component instanceof HtmlInputTextHelp) {
            HtmlInputTextHelp helpTextComp = (HtmlInputTextHelp)component;
            return helpTextComp.isSelectText();
        }
        return false;
    }

    public static String getHelpText(UIComponent component) {
        HtmlInputTextHelp helpTextComp;
        if (component instanceof HtmlInputTextHelp && (helpTextComp = (HtmlInputTextHelp)component).getHelpText() != null) {
            return helpTextComp.getHelpText();
        }
        return null;
    }

    public void renderInputTextHelp(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("id", (Object)input.getClientId(facesContext), null);
        writer.writeAttribute("name", (Object)input.getClientId(facesContext), null);
        writer.writeAttribute("type", (Object)"text", null);
        this.renderHelpTextAttributes((UIComponent)input, writer, facesContext);
        String value = RendererUtils.getStringValue(facesContext, (UIComponent)input);
        value = value == null || value.length() == 0 ? HtmlTextHelpRenderer.getHelpText((UIComponent)input) : value;
        writer.writeAttribute("value", (Object)value, "value");
        writer.endElement("input");
    }

    private void renderHelpTextAttributes(UIComponent component, ResponseWriter writer, FacesContext facesContext) throws IOException {
        if (!(component instanceof HtmlInputTextHelp)) {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        } else {
            String id = component.getClientId(facesContext);
            if (HtmlTextHelpRenderer.isSelectText(component)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK);
                writer.writeAttribute("onfocus", (Object)("selectText('" + HtmlTextHelpRenderer.getHelpText(component) + "', '" + id + "')"), null);
                writer.writeAttribute("onclick", (Object)("selectText('" + HtmlTextHelpRenderer.getHelpText(component) + "', '" + id + "')"), null);
            } else if (HtmlTextHelpRenderer.getHelpText(component) != null) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONFOCUS_AND_ONCLICK);
                writer.writeAttribute("onfocus", (Object)("resetHelpValue('" + HtmlTextHelpRenderer.getHelpText(component) + "', '" + id + "')"), null);
                writer.writeAttribute("onclick", (Object)("resetHelpValue('" + HtmlTextHelpRenderer.getHelpText(component) + "', '" + id + "')"), null);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
            }
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue != null && component instanceof HtmlInputTextHelp && ((HtmlInputTextHelp)component).getHelpText() != null && submittedValue.equals(((HtmlInputTextHelp)component).getHelpText())) {
            submittedValue = "";
        }
        return super.getConvertedValue(facesContext, component, submittedValue);
    }

    public static void addJavaScriptResources(FacesContext facesContext) {
        if (facesContext.getExternalContext().getRequestMap().containsKey(JAVASCRIPT_ENCODED)) {
            return;
        }
        AddResourceFactory.getInstance(facesContext).addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$inputTextHelp$HtmlTextHelpRenderer == null ? (class$org$apache$myfaces$custom$inputTextHelp$HtmlTextHelpRenderer = HtmlTextHelpRenderer.class$("org.apache.myfaces.custom.inputTextHelp.HtmlTextHelpRenderer")) : class$org$apache$myfaces$custom$inputTextHelp$HtmlTextHelpRenderer, "inputTextHelp.js");
        facesContext.getExternalContext().getRequestMap().put(JAVASCRIPT_ENCODED, Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

