/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.spring;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.Util;

public class SpringProject {
    private IProject project;
    private List configFiles = new ArrayList();

    public SpringProject(IProject project, String root) {
        this.project = project;
        IFile springBeans = project.getFile(".springBeans");
        if (springBeans.exists()) {
            try {
                this.parseSpringBeansXML(springBeans.getContents());
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
        } else {
            IFile file = project.getProject().getFile(String.valueOf(root) + "/WEB-INF/applicationContext.xml");
            if (file.exists()) {
                this.configFiles.add(file);
            }
        }
    }

    private void parseSpringBeansXML(InputStream in) throws Exception {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(in);
        FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/beansProjectDescription/configs/config");
        int i = 0;
        while (i < nodes.length) {
            IFile file;
            String value = ((FuzzyXMLElement)nodes[i]).getValue();
            if (value != null && (file = this.project.getFile(value.trim())).exists()) {
                this.configFiles.add(file);
            }
            ++i;
        }
    }

    public IFile[] getSpringConfigFiles() {
        return this.configFiles.toArray(new IFile[this.configFiles.size()]);
    }
}

