/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.validator;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.validator.FacesConfigValidator;
import tk.eclipse.plugin.jsf.validator.FacesJSPValidator;

public class JSFProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null) {
            return null;
        }
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta == null) {
            return null;
        }
        if (kind == 6) {
            JSFProject project = new JSFProject(JavaCore.create((IProject)this.getProject()));
            this.fullValidation(project);
        } else {
            BuildInfo info = this.processDelta(delta);
            if (info != null) {
                JSFProject project = new JSFProject(JavaCore.create((IProject)this.getProject()));
                if (info.fullBuild) {
                    this.fullValidation(project);
                } else {
                    this.validateFacesConfig(project);
                    this.validateJSP(project, info.buildFile);
                }
            }
        }
        this.getProject().refreshLocal(2, monitor);
        return null;
    }

    private BuildInfo processDelta(IResourceDelta delta) {
        if (delta.getKind() != 0) {
            String path = delta.getProjectRelativePath().toString();
            if (path.endsWith(".project") || path.endsWith(".classpath") || path.endsWith(".java") || path.endsWith(".class") || path.endsWith(".xml")) {
                BuildInfo info = new BuildInfo();
                info.fullBuild = true;
                return info;
            }
            if (path.endsWith(".jsp")) {
                BuildInfo info = new BuildInfo();
                info.buildFile = this.getProject().getFile(delta.getProjectRelativePath());
                return info;
            }
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            BuildInfo info = this.processDelta(children[i]);
            if (info != null) {
                return info;
            }
            ++i;
        }
        return null;
    }

    private void fullValidation(JSFProject project) {
        this.validateFacesConfig(project);
        this.validateContainer(project, (IContainer)this.getProject());
    }

    private void validateFacesConfig(JSFProject project) {
        IFile[] files = project.getFacesConfigXML();
        int i = 0;
        while (i < files.length) {
            new FacesConfigValidator(files[i]).doValidate();
            ++i;
        }
    }

    private void validateContainer(JSFProject project, IContainer folder) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    if (resources[i].getName().endsWith(".jsp")) {
                        this.validateJSP(project, this.getProject().getFile(resources[i].getProjectRelativePath()));
                    }
                } else if (resources[i] instanceof IContainer) {
                    this.validateContainer(project, (IContainer)resources[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateJSP(JSFProject project, IFile file) {
        if (file.getName().startsWith(".")) {
            return;
        }
        new FacesJSPValidator(project, file).doValidate();
    }

    private class BuildInfo {
        private boolean fullBuild = false;
        private IFile buildFile = null;

        BuildInfo() {
        }
    }
}

