/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorPart;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

public class VisualJSFUtil {
    public static void removeProperty(IType clazz, String name) {
        if (clazz == null) {
            return;
        }
        try {
            IField field = clazz.getField(name);
            if (field != null && field.exists()) {
                IMethod[] methods = clazz.getMethods();
                String setter = HTMLUtil.getSetterName((String)name);
                String getter = HTMLUtil.getGetterName((String)name, (boolean)false);
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getElementName().equals(setter)) {
                        methods[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
                    } else if (methods[i].getElementName().equals(getter)) {
                        methods[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++i;
                }
                field.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            VisualJSFPlugin.logException(ex);
        }
    }

    public static void renameProperty(IType clazz, String from, String to, String type) {
        if (type == null) {
            return;
        }
        VisualJSFUtil.removeProperty(clazz, from);
        VisualJSFUtil.createProperty(clazz, to, type);
    }

    public static String getBackingBeanName(String pageName) {
        String beanName = pageName.substring(0, pageName.lastIndexOf(46));
        if (beanName.startsWith("/")) {
            beanName = beanName.substring(1);
        }
        beanName = beanName.replaceAll("/|\\\\|\\.", "_");
        return beanName;
    }

    public static String getBackingBeanClassName(String pageName) {
        String className = pageName.substring(0, pageName.lastIndexOf(46));
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        className = className.replaceAll("/|\\\\|\\.", "_");
        className = String.valueOf(className.substring(0, 1).toUpperCase()) + className.substring(1);
        return className;
    }

    public static void createProperty(IType clazz, String name, String type) {
        if (clazz == null) {
            return;
        }
        try {
            clazz.createField("private " + type + " " + name + ";", null, false, (IProgressMonitor)new NullProgressMonitor());
            clazz.createMethod("public void " + HTMLUtil.getSetterName((String)name) + "(" + type + " " + name + "){\n" + "\tthis." + name + " = " + name + ";\n" + "}\n", null, false, (IProgressMonitor)new NullProgressMonitor());
            clazz.createMethod("public " + type + " " + HTMLUtil.getGetterName((String)name, (boolean)false) + "(){\n" + "\treturn this." + name + ";\n" + "}\n", null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            VisualJSFPlugin.logException(ex);
        }
    }

    public static void createActionMethod(IType clazz, String name, String value) {
        if (clazz == null) {
            return;
        }
        try {
            if (value == null) {
                clazz.createMethod("public String " + name + "(){\n" + "\treturn null;\n" + "}\n", null, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                clazz.createMethod("public String " + name + "(){\n" + "\treturn \"" + value + "\";\n" + "}\n", null, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            VisualJSFPlugin.logException(ex);
        }
    }

    public static void openJavaElement(IJavaElement element) {
        try {
            JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)element), (IJavaElement)element);
        }
        catch (Exception ex) {
            VisualJSFPlugin.logException(ex);
        }
    }
}

