/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.descriptors.ManagedBeanMethod;

public class ActionSelectionDialog
extends SelectionDialog {
    private TreeViewer viewer;
    private ManagedBean[] beans;
    private ManagedBeanMethod initial;

    public ActionSelectionDialog(Shell parentShell, ManagedBean[] beans, ManagedBeanMethod initial) {
        super(parentShell);
        this.setTitle(VisualJSFPlugin.getResourceString("dialog.chooseAction"));
        this.beans = beans;
        this.initial = initial;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        return new Point(350, 300);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.initial != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.initial), true);
        }
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(composite);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ValueContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ValueLabelProvider());
        this.viewer.setInput((Object)this.beans);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof ManagedBeanMethod) {
                    ActionSelectionDialog.this.setSelectionResult(new Object[]{obj});
                    ActionSelectionDialog.this.getButton(0).setEnabled(true);
                } else {
                    ActionSelectionDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        return composite;
    }

    private class ValueContentProvider
    implements ITreeContentProvider {
        ValueContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ManagedBean) {
                String[] methodNames = ((ManagedBean)parentElement).getActionMethodNames();
                Object[] methods = new ManagedBeanMethod[methodNames.length];
                int i = 0;
                while (i < methodNames.length) {
                    methods[i] = new ManagedBeanMethod((ManagedBean)parentElement, methodNames[i]);
                    ++i;
                }
                return methods;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ManagedBeanMethod) {
                return ((ManagedBeanMethod)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return (ManagedBean[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ValueLabelProvider
    extends LabelProvider {
        ValueLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ManagedBean) {
                return JSFPlugin.getDefault().getImage("__icon_class");
            }
            if (element instanceof ManagedBeanMethod) {
                return JSFPlugin.getDefault().getImage("__icon_method");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ManagedBean) {
                return String.valueOf(((ManagedBean)element).getBeanName()) + " - " + ((ManagedBean)element).getClassName();
            }
            if (element instanceof ManagedBeanMethod) {
                return ((ManagedBeanMethod)element).getMethodName();
            }
            return super.getText(element);
        }
    }
}

