/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.RootModel;

public abstract class AbstractJSFEditPart
extends AbstractEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
    }

    protected void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof AbstractJSFModel) {
            Rectangle constraint = ((AbstractJSFModel)model).getConstraint();
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setRootModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }

    private class DeleteCommand
    extends Command {
        private RootModel root;
        private AbstractJSFModel model;

        DeleteCommand() {
        }

        public void execute() {
            this.root.removeChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (AbstractJSFModel)model;
        }

        public void undo() {
            this.root.addChild(this.model);
        }
    }
}

