/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.AbstractModel;
import tk.eclipse.plugin.visualjsf.models.RootModel;

public class RootEditPart
extends AbstractEditPart {
    protected IFigure createFigure() {
        Layer figure = new Layer(){

            protected void paintFigure(Graphics graphics) {
                graphics.setForegroundColor(Display.getCurrent().getSystemColor(15));
                int x = 10;
                while (x < this.getSize().width) {
                    int y = 10;
                    while (y < this.getSize().height) {
                        graphics.drawPoint(x, y);
                        y += 10;
                    }
                    x += 10;
                }
            }
        };
        figure.setLayoutManager((LayoutManager)new XYLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
    }

    protected List getModelChildren() {
        List list = ((RootModel)this.getModel()).getChildren();
        ArrayList models = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof AbstractModel) {
                models.add(obj);
            }
            ++i;
        }
        return models;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_children")) {
            this.refreshChildren();
        }
    }

    private class RootEditPolicy
    extends XYLayoutEditPolicy {
        RootEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new ResizableEditPolicy(){

                protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                    IFigure feedback = this.getDragSourceFeedbackFigure();
                    PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    rect.translate(request.getMoveDelta());
                    rect.resize(request.getSizeDelta());
                    RootEditPolicy.this.snapToGrid((Rectangle)rect);
                    feedback.translateToRelative((Translatable)rect);
                    feedback.setBounds((Rectangle)rect);
                }
            };
        }

        protected void showSizeOnDropFeedback(CreateRequest request) {
            Point p = new Point(request.getLocation().getCopy());
            IFigure feedback = this.getSizeOnDropFeedback(request);
            feedback.translateToRelative((Translatable)p);
            Dimension size = request.getSize().getCopy();
            feedback.translateToRelative((Translatable)size);
            Rectangle rectangle = new Rectangle(p, size).expand(this.getCreationFeedbackOffset(request));
            this.snapToGrid(rectangle);
            feedback.setBounds(rectangle);
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            Rectangle rectangle = (Rectangle)constraint;
            this.snapToGrid(rectangle);
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            command.setModel((AbstractJSFModel)child.getModel());
            command.setConstraint(rectangle);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateCommand command = new CreateCommand();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            this.snapToGrid(constraint);
            AbstractJSFModel model = (AbstractJSFModel)request.getNewObject();
            model.setConstraint(constraint);
            command.setRootModel(this.getHost().getModel());
            command.setModel(model);
            return command;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }

        private void snapToGrid(Rectangle rectangle) {
            rectangle.x = this.roundValue(rectangle.x);
            rectangle.y = this.roundValue(rectangle.y);
            rectangle.width = this.roundValue(rectangle.width);
            rectangle.height = this.roundValue(rectangle.height);
        }

        private int roundValue(int value) {
            int div = value % 10;
            if (div >= 5) {
                return value + (10 - div);
            }
            return value - div;
        }
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractJSFModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractJSFModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateCommand
    extends Command {
        private RootModel root;
        private AbstractJSFModel model;

        CreateCommand() {
        }

        public void execute() {
            this.root.addChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setModel(Object model) {
            this.model = (AbstractJSFModel)model;
        }

        public void undo() {
            this.root.removeChild(this.model);
        }
    }
}

