/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.draw2d.geometry.Rectangle;
import tk.eclipse.plugin.visualjsf.loader.IElementLoader;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;

public abstract class AbstractElementLoader
implements IElementLoader {
    public AbstractJSFModel load(FuzzyXMLElement element) {
        AbstractJSFModel model = this.loadModel(element);
        model.setName(this.getString(element, "id"));
        model.setConstraint(this.getConstraint(element));
        return model;
    }

    protected abstract AbstractJSFModel loadModel(FuzzyXMLElement var1);

    protected String getString(FuzzyXMLElement element, String attr) {
        String value = element.getAttributeValue(attr);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected boolean getBoolean(FuzzyXMLElement element, String attr) {
        String value = element.getAttributeValue(attr);
        return value != null && !value.equals("false");
    }

    protected Rectangle getConstraint(FuzzyXMLElement element) {
        String style = this.getString(element, "style");
        String[] styles = style.split(";");
        Rectangle rect = new Rectangle();
        int i = 0;
        while (i < styles.length) {
            if (styles[i].trim().length() != 0) {
                String[] dim = styles[i].split(":");
                String name = dim[0].trim();
                String value = dim[1].trim();
                if (name.equals("left")) {
                    rect.x = Integer.parseInt(value);
                } else if (name.equals("top")) {
                    rect.y = Integer.parseInt(value);
                } else if (name.equals("width")) {
                    rect.width = Integer.parseInt(value);
                } else if (name.equals("height")) {
                    rect.height = Integer.parseInt(value);
                }
            }
            ++i;
        }
        return rect;
    }

    protected String getStyle(FuzzyXMLElement element, String styleName) {
        String style = this.getString(element, "style");
        String[] styles = style.split(";");
        int i = 0;
        while (i < styles.length) {
            if (styles[i].trim().length() != 0) {
                String[] dim = styles[i].split(":");
                String name = dim[0].trim();
                String value = dim[1].trim();
                if (name.equals(styleName)) {
                    return value;
                }
            }
            ++i;
        }
        return null;
    }
}

