/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.loader;

import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.loader.ElementLoaderFactory;
import tk.eclipse.plugin.visualjsf.loader.IElementLoader;
import tk.eclipse.plugin.visualjsf.models.RootModel;

public class VisualJSFLoader {
    public static RootModel loadJSP(String source, Set componentNames) throws Exception {
        RootModel root = new RootModel(componentNames);
        FuzzyXMLParser parser = new FuzzyXMLParser();
        source = HTMLUtil.scriptlet2space((String)source, (boolean)true);
        FuzzyXMLDocument doc = parser.parse(source);
        FuzzyXMLElement element = doc.getDocumentElement();
        FuzzyXMLElement form = VisualJSFLoader.getFormElement(element);
        FuzzyXMLNode[] children = form.getChildren();
        int i = 0;
        while (i < children.length) {
            String name;
            if (children[i] instanceof FuzzyXMLElement && ((name = ((FuzzyXMLElement)children[i]).getName()).startsWith("h:") || name.startsWith("f:"))) {
                VisualJSFLoader.processElement((FuzzyXMLElement)children[i], root);
            }
            ++i;
        }
        return root;
    }

    private static void processElement(FuzzyXMLElement element, RootModel root) {
        IElementLoader loader = ElementLoaderFactory.getElementLoader(element);
        if (loader != null) {
            root.addChild(loader.load(element));
        }
    }

    private static FuzzyXMLElement getFormElement(FuzzyXMLElement element) {
        FuzzyXMLNode[] nodes = element.getChildren();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                if (((FuzzyXMLElement)nodes[i]).getName().equals("h:form")) {
                    return (FuzzyXMLElement)nodes[i];
                }
                FuzzyXMLElement result = VisualJSFLoader.getFormElement((FuzzyXMLElement)nodes[i]);
                if (result != null) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }
}

