/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import tk.eclipse.plugin.visualjsf.models.ModelProperty;

public abstract class AbstractModel
implements IPropertySource {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map properties = new HashMap();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void addModelProperty(Object id, ModelProperty property) {
        this.properties.put(id, property);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        Iterator ite = this.properties.values().iterator();
        while (ite.hasNext()) {
            ModelProperty property = (ModelProperty)ite.next();
            descriptors.add(property.getDecriptor());
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        ModelProperty property = (ModelProperty)this.properties.get(id);
        return property.getProperty();
    }

    public boolean isPropertySet(Object id) {
        return this.properties.containsKey(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        ModelProperty property = (ModelProperty)this.properties.get(id);
        property.setProperty(value);
    }

    public Object getEditableValue() {
        return this;
    }

    public abstract String toHTML();
}

