/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.visualjsf.models;

import java.lang.reflect.Method;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class ModelProperty {
    private Object model;
    private String setterMethod;
    private String getterMethod;
    private Class type;
    private IPropertyDescriptor descriptor;

    public ModelProperty(Object model, String propertyName, Class type, IPropertyDescriptor descriptor) {
        this(model, propertyName, type, descriptor, "General");
    }

    public ModelProperty(Object model, String propertyName, Class type, IPropertyDescriptor descriptor, String category) {
        this.model = model;
        this.setterMethod = HTMLUtil.getSetterName((String)propertyName);
        this.getterMethod = HTMLUtil.getGetterName((String)propertyName, (boolean)false);
        this.type = type;
        this.descriptor = descriptor;
        ((PropertyDescriptor)this.descriptor).setCategory(category);
    }

    public void setProperty(Object value) {
        try {
            Method setter = this.getSetterMethod();
            setter.invoke(this.model, value);
        }
        catch (Exception ex) {
            HTMLPlugin.logException((Throwable)ex);
        }
    }

    public Object getProperty() {
        try {
            Method getter = this.getGetterMethod();
            return getter.invoke(this.model, new Object[0]);
        }
        catch (Exception ex) {
            HTMLPlugin.logException((Throwable)ex);
            return null;
        }
    }

    private Method getSetterMethod() throws Exception {
        Class<?> clazz = this.model.getClass();
        Method setter = clazz.getMethod(this.setterMethod, this.type);
        return setter;
    }

    private Method getGetterMethod() throws Exception {
        Class<?> clazz = this.model.getClass();
        Method getter = clazz.getMethod(this.getterMethod, new Class[0]);
        return getter;
    }

    public IPropertyDescriptor getDecriptor() {
        return this.descriptor;
    }
}

