/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.stepcounter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import tk.eclipse.plugin.stepcounter.StepCounterPlugin;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;
import tk.stepcounter.StepCounterFactory;

public class StepCountView
extends ViewPart {
    private Table table;
    private Menu popup;
    private MenuItem copy;
    private MenuItem selectAll;
    private MenuItem clear;
    private MenuItem open;
    private Clipboard clipboard;
    private static String file = StepCounterPlugin.getResourceString("StepCountView.columnName");
    private static String type = StepCounterPlugin.getResourceString("StepCountView.columnType");
    private static String step = StepCounterPlugin.getResourceString("StepCountView.columnStep");
    private static String none = StepCounterPlugin.getResourceString("StepCountView.columnNone");
    private static String comment = StepCounterPlugin.getResourceString("StepCountView.columnComment");
    private static String total = StepCounterPlugin.getResourceString("StepCountView.columnTotal");
    private HashMap files = new HashMap();

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] cols = new String[]{file, type, step, none, comment, total};
        int i = 0;
        while (i < cols.length) {
            TableColumn col = null;
            col = i == 0 || i == 1 ? new TableColumn(this.table, 16384) : new TableColumn(this.table, 131072);
            col.setText(cols[i]);
            if (i == 0) {
                col.setWidth(250);
            } else {
                col.setWidth(80);
            }
            col.addSelectionListener((SelectionListener)new TableHeaderListener());
            ++i;
        }
        this.clipboard = new Clipboard(parent.getDisplay());
        this.popup = new Menu((Decorations)this.table.getShell(), 8);
        this.open = new MenuItem(this.popup, 8);
        this.open.setText(StepCounterPlugin.getResourceString("StepCountView.menuOpen"));
        this.open.addSelectionListener((SelectionListener)new TableOpenListener());
        this.copy = new MenuItem(this.popup, 8);
        this.copy.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy"));
        this.copy.addSelectionListener((SelectionListener)new TableCopyListener());
        this.selectAll = new MenuItem(this.popup, 8);
        this.selectAll.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll"));
        this.selectAll.addSelectionListener((SelectionListener)new TableSelectAllListener());
        new MenuItem(this.popup, 2);
        this.clear = new MenuItem(this.popup, 8);
        this.clear.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear"));
        this.clear.addSelectionListener((SelectionListener)new TableClearListener());
        this.table.addMouseListener((MouseListener)new TableMouseListener());
    }

    public void count(ISelection selection) {
        this.table.removeAll();
        this.files.clear();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection iSel = (IStructuredSelection)selection;
            Iterator ite = iSel.iterator();
            long totalStep = 0L;
            long totalComment = 0L;
            long totalNone = 0L;
            while (ite.hasNext()) {
                Object obj = ite.next();
                CountResult result = null;
                if (obj instanceof ICompilationUnit) {
                    ICompilationUnit file = (ICompilationUnit)obj;
                    result = this.countFile((IFile)file.getResource());
                } else if (obj instanceof IPackageFragment) {
                    IPackageFragment pkg = (IPackageFragment)obj;
                    result = this.countPackage(pkg);
                } else if (obj instanceof IFile) {
                    result = this.countFile((IFile)obj);
                } else if (obj instanceof IFolder) {
                    result = this.countFolder((IFolder)obj);
                }
                if (result == null) continue;
                totalStep += result.getStep();
                totalNone += result.getNon();
                totalComment += result.getComment();
            }
            String[] data = new String[]{total, "", String.valueOf(totalStep), String.valueOf(totalNone), String.valueOf(totalComment), String.valueOf(totalStep + totalNone + totalComment)};
            TableItem item = new TableItem(this.table, 0);
            item.setText(data);
        }
    }

    private CountResult countFile(IFile file) {
        try {
            StepCounter counter = StepCounterFactory.getCounter(file.getName());
            if (counter != null) {
                CountResult result = counter.count(file.getLocation().makeAbsolute().toFile());
                String type = result.getFileType();
                long comment = result.getComment();
                long none = result.getNon();
                long step = result.getStep();
                String[] data = new String[]{file.getFullPath().toString(), type, String.valueOf(step), String.valueOf(none), String.valueOf(comment), String.valueOf(step + none + comment)};
                TableItem item = new TableItem(this.table, 0);
                item.setText(data);
                this.files.put(file.getFullPath().toString(), file);
                return result;
            }
            String[] data = new String[]{file.getFullPath().toString(), StepCounterPlugin.getResourceString("StepCountView.notSupported"), "", "", "", ""};
            TableItem item = new TableItem(this.table, 0);
            item.setText(data);
            this.files.put(file.getFullPath().toString(), file);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private CountResult countFolder(IFolder folder) {
        CountResult result = new CountResult();
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                CountResult count;
                if (children[i] instanceof IFile) {
                    count = this.countFile((IFile)children[i]);
                    if (count != null) {
                        result.setStep(result.getStep() + count.getStep());
                        result.setNon(result.getNon() + count.getNon());
                        result.setComment(result.getComment() + count.getComment());
                    }
                } else if (children[i] instanceof IFolder) {
                    count = this.countFolder((IFolder)children[i]);
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private CountResult countPackage(IPackageFragment pkg) {
        CountResult result = new CountResult();
        try {
            ICompilationUnit[] files = pkg.getCompilationUnits();
            int i = 0;
            while (i < files.length) {
                CountResult count = this.countFile((IFile)files[i].getResource());
                if (count != null) {
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i;
            }
            Object[] obj = pkg.getNonJavaResources();
            int i2 = 0;
            while (i2 < obj.length) {
                CountResult count = this.countFile((IFile)obj[i2]);
                if (count != null) {
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setFocus() {
        this.table.setFocus();
    }

    private void updatePopupMenu() {
        TableItem[] items = this.table.getItems();
        if (items.length == 0) {
            this.selectAll.setEnabled(false);
            this.clear.setEnabled(false);
        } else {
            this.selectAll.setEnabled(true);
            this.clear.setEnabled(true);
        }
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            this.copy.setEnabled(false);
        } else {
            this.copy.setEnabled(true);
        }
        this.open.setEnabled(false);
        int i = 0;
        while (i < selection.length) {
            String filePath = selection[i].getText(0);
            if (this.files.get(filePath) != null) {
                this.open.setEnabled(true);
                break;
            }
            ++i;
        }
    }

    private void openEditor() {
        TableItem[] items = this.table.getSelection();
        int i = 0;
        while (i < items.length) {
            try {
                String filePath = items[i].getText(0);
                if (this.files.get(filePath) != null) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)((IFile)this.files.get(filePath)), (boolean)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private class TableHeaderListener
    extends SelectionAdapter {
        TableHeaderListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                TableColumn column = (TableColumn)e.getSource();
                int sortColumn = 0;
                String name = column.getText();
                if (name.equals(file)) {
                    sortColumn = 0;
                } else if (name.equals(type)) {
                    sortColumn = 1;
                } else if (name.equals(step)) {
                    sortColumn = 2;
                } else if (name.equals(none)) {
                    sortColumn = 3;
                } else if (name.equals(comment)) {
                    sortColumn = 4;
                } else if (name.equals(total)) {
                    sortColumn = 5;
                }
                TableItem[] items = StepCountView.this.table.getItems();
                ArrayList<String[]> list = new ArrayList<String[]>();
                int i = 0;
                while (i < items.length) {
                    list.add(new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)});
                    ++i;
                }
                Object[] datas = list.toArray();
                Arrays.sort(datas, new TableComparator(sortColumn));
                StepCountView.this.table.removeAll();
                int i2 = 0;
                while (i2 < datas.length) {
                    TableItem item = new TableItem(StepCountView.this.table, 0);
                    item.setText((String[])datas[i2]);
                    ++i2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TableComparator
    implements Comparator {
        private int index = 0;

        public TableComparator(int index) {
            this.index = index;
        }

        public int compare(Object obj1, Object obj2) {
            String[] data1 = (String[])obj1;
            String[] data2 = (String[])obj2;
            if (data1[0].equals(total)) {
                return 1;
            }
            if (data2[0].equals(total)) {
                return -1;
            }
            if (this.index >= 2) {
                long value1 = 0L;
                long value2 = 0L;
                if (data1[this.index] != null && !data1[this.index].equals("")) {
                    value1 = Long.parseLong(data1[this.index]);
                }
                if (data2[this.index] != null && !data2[this.index].equals("")) {
                    value2 = Long.parseLong(data2[this.index]);
                }
                if (value1 == value2) {
                    return 0;
                }
                if (value1 > value2) {
                    return -1;
                }
                return 1;
            }
            String value1 = data1[this.index];
            String value2 = data2[this.index];
            return value1.compareTo(value2);
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 3) {
                StepCountView.this.updatePopupMenu();
                StepCountView.this.popup.setVisible(true);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            StepCountView.this.openEditor();
        }
    }

    private class TableOpenListener
    extends SelectionAdapter {
        TableOpenListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StepCountView.this.openEditor();
        }
    }

    private class TableCopyListener
    extends SelectionAdapter {
        TableCopyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items = StepCountView.this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                sb.append(items[i].getText(0));
                sb.append("\t");
                sb.append(items[i].getText(1));
                sb.append("\t");
                sb.append(items[i].getText(2));
                sb.append("\t");
                sb.append(items[i].getText(3));
                sb.append("\t");
                sb.append(items[i].getText(4));
                sb.append("\t");
                sb.append(items[i].getText(5));
                sb.append("\n");
                ++i;
            }
            TextTransfer transfer = TextTransfer.getInstance();
            StepCountView.this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{transfer});
        }
    }

    private class TableSelectAllListener
    extends SelectionAdapter {
        TableSelectAllListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StepCountView.this.table.selectAll();
        }
    }

    private class TableClearListener
    extends SelectionAdapter {
        TableClearListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StepCountView.this.table.removeAll();
        }
    }
}

