/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import tk.stepcounter.gui.StringUtility;

public class ConfigManager {
    private File file;
    private HashMap map;

    public ConfigManager(String fileName) {
        this(new File(fileName));
    }

    public ConfigManager(File file) {
        this.file = file;
        try {
            this.read();
        }
        catch (Exception e) {
            this.map = new HashMap();
        }
    }

    public void setProperty(String key, String value) {
        String[] values = new String[]{value};
        this.setProperty(key, values);
    }

    public void setProperty(String key, String[] values) {
        Vector<String> vec = new Vector<String>();
        int i = 0;
        while (i < values.length) {
            vec.add(values[i]);
            ++i;
        }
        this.map.put(key, vec);
    }

    public String getProperty(String key) {
        String[] values = this.getPropertyValues(key);
        if (values != null && values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getPropertyValues(String key) {
        if (this.map.get(key) == null) {
            return null;
        }
        Vector vec = (Vector)this.map.get(key);
        String[] dim = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            dim[i] = (String)vec.get(i);
            ++i;
        }
        return dim;
    }

    private synchronized void read() throws IOException {
        String line;
        this.map = new HashMap();
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        while ((line = reader.readLine()) != null) {
            String[] dim;
            line.trim();
            if (line.startsWith("#") || (dim = StringUtility.split(line, "=")).length < 2) continue;
            String key = dim[0].trim();
            String value = dim[1].trim();
            Vector values = this.map.get(key) == null ? new Vector() : (Vector)this.map.get(key);
            values.add(value);
            this.map.put(key, values);
        }
        reader.close();
    }

    public synchronized void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        writer.write("# Date: " + formatter.format(new Date()));
        writer.newLine();
        Set set = this.map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Vector values = (Vector)this.map.get(key);
            int i = 0;
            while (i < values.size()) {
                writer.write(String.valueOf(key) + "=" + (String)values.get(i));
                writer.newLine();
                ++i;
            }
        }
        writer.flush();
        writer.close();
    }
}

