/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import java.util.ResourceBundle;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.IPaletteTarget;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.FacesConfigOutlinePage;
import tk.eclipse.plugin.jsf.editors.FacesConfigXMLEditor;
import tk.eclipse.plugin.jsf.editors.ManagedBeanEditor;
import tk.eclipse.plugin.jsf.editors.NavigationEditor;

public class MultiPageFacesConfigEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IPaletteTarget {
    private NavigationEditor navigationEditor;
    private FacesConfigXMLEditor sourceEditor;
    private ManagedBeanEditor managedBeanEditor;
    private FacesConfigOperation operation;
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
    private FacesConfigOutlinePage outlinePage;
    public static final int INDEX_NAVIGATION_EDITOR = 0;
    public static final int INDEX_MANAGED_BEAN_EDITOR = 1;
    public static final int INDEX_SOURCE_EDITOR = 2;
    boolean firstFlag = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MultiPageFacesConfigEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.operation = new FacesConfigOperation(this, new SynchronizeSourceEditorListener());
    }

    public HTMLSourceEditor getPaletteTarget() {
        return this.sourceEditor;
    }

    private FacesConfigOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new FacesConfigOutlinePage(this.navigationEditor, this.sourceEditor);
        }
        return this.outlinePage;
    }

    private void createPage0() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.navigationEditor = new NavigationEditor(this.operation);
                int index = this.addPage((IEditorPart)this.navigationEditor, this.getEditorInput());
                this.setPageText(index, this.resource.getString("editor.tab.flow"));
            }
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage1() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.managedBeanEditor = new ManagedBeanEditor(this.operation);
                int index = this.addPage((IEditorPart)this.managedBeanEditor, this.getEditorInput());
                this.setPageText(index, this.resource.getString("editor.tab.managedbean"));
            }
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage2() {
        try {
            this.sourceEditor = new FacesConfigXMLEditor();
            int index = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(index, this.resource.getString("editor.tab.source"));
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.createPage2();
        this.syncEditors(0);
        this.syncEditors(1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        int page = this.getActivePage();
        if (page == 2) {
            this.syncEditors(0);
            this.syncEditors(1);
        }
        this.sourceEditor.doSave(monitor);
        if (this.managedBeanEditor != null) {
            this.managedBeanEditor.doSave(monitor);
        }
        if (this.navigationEditor != null) {
            this.navigationEditor.doSave();
            this.navigationEditor.flushCommandStack();
        }
    }

    public void doSaveAs() {
        int page = this.getActivePage();
        if (page == 2) {
            this.syncEditors(0);
            this.syncEditors(1);
        }
        this.sourceEditor.doSaveAs();
        this.managedBeanEditor.doSaveAs();
        this.setInput(this.sourceEditor.getEditorInput());
        this.navigationEditor.doSave(this.sourceEditor.getEditorInput());
        this.setPartName(this.sourceEditor.getEditorInput().getName());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        if (this.isDirty()) {
            this.syncEditors(newPageIndex);
            this.sourceEditor.updateEditor();
        }
        super.pageChange(newPageIndex);
    }

    public void syncEditors(int page) {
        try {
            if (!this.sourceEditor.isFileEditorInput()) {
                return;
            }
            this.operation.setAllowOperation(false);
            if (page == 0) {
                this.navigationEditor.update(this.getDocument().get());
            } else if (page == 1) {
                this.managedBeanEditor.update(this.getDocument().get());
            }
        }
        finally {
            this.operation.setAllowOperation(true);
        }
    }

    public IDocument getDocument() {
        IEditorInput input = this.sourceEditor.getEditorInput();
        IDocument doc = this.sourceEditor.getDocumentProvider().getDocument((Object)input);
        return doc;
    }

    public void setFocus() {
        if (this.firstFlag) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firstFlag = false;
        }
        super.setFocus();
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.sourceEditor.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)MultiPageFacesConfigEditor.this, false);
                    } else if (!MultiPageFacesConfigEditor.this.getPartName().equals(file.getName())) {
                        MultiPageFacesConfigEditor.this.setPartName(file.getName());
                    } else if (HTMLUtil.contains((IResourceDelta)event.getDelta(), (IFile)file)) {
                        MultiPageFacesConfigEditor.this.syncEditors(0);
                        MultiPageFacesConfigEditor.this.syncEditors(1);
                        MultiPageFacesConfigEditor.this.navigationEditor.updateIconStatus();
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            this.setActivePage(2);
            return this.sourceEditor.getAdapter(adapter);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            return this.sourceEditor;
        }
        if (this.getActiveEditor() == this.sourceEditor) {
            return this.sourceEditor.getAdapter(adapter);
        }
        if (this.navigationEditor != null) {
            return this.navigationEditor.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    private class SynchronizeSourceEditorListener
    implements FuzzyXMLModifyListener {
        private SynchronizeSourceEditorListener() {
        }

        public void modified(FuzzyXMLModifyEvent evt) {
            try {
                IEditorInput input = MultiPageFacesConfigEditor.this.sourceEditor.getEditorInput();
                IDocument doc = MultiPageFacesConfigEditor.this.sourceEditor.getDocumentProvider().getDocument((Object)input);
                doc.replace(evt.getOffset(), evt.getLength(), evt.getNewText());
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
        }
    }
}

