package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;

public abstract class AbstractBindingSelectionDialog extends SelectionDialog {

	private TreeViewer viewer;
	private ManagedBean[] beans;
	private ManagedBeanMethod initial;

	public AbstractBindingSelectionDialog(Shell parentShell, String title, ManagedBean[] beans, ManagedBeanMethod initial) {
		super(parentShell);
		setTitle(title);
		this.beans = beans;
		this.initial = initial;
		setShellStyle(getShellStyle() | SWT.RESIZE);
	}

	protected Point getInitialSize() {
		return new Point(350, 300);
	}

	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		if(this.initial!=null){
			this.viewer.setSelection(new StructuredSelection(this.initial), true);
		}
		return control;
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, true));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		this.viewer = new TreeViewer(composite);
		viewer.getTree().setLayoutData(new GridData(GridData.FILL_BOTH));
		viewer.setContentProvider(new ValueContentProvider());
		viewer.setLabelProvider(new ValueLabelProvider());
		viewer.setInput(this.beans);
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event){
				IStructuredSelection sel = (IStructuredSelection)event.getSelection();
				Object obj = sel.getFirstElement();
				if(obj instanceof ManagedBeanMethod){
					setSelectionResult(new Object[]{obj});
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				} else {
					getButton(IDialogConstants.OK_ID).setEnabled(false);
				}
			}
		});
		return composite;
	}
	
	protected abstract String[] getMethodNames(ManagedBean bean);
	
	private class ValueContentProvider implements ITreeContentProvider {

		public Object[] getChildren(Object parentElement) {
			if(parentElement instanceof ManagedBean){
				String[] methodNames = getMethodNames((ManagedBean)parentElement);
				ManagedBeanMethod[] methods = new ManagedBeanMethod[methodNames.length];
				for(int i=0;i<methodNames.length;i++){
					methods[i] = new ManagedBeanMethod((ManagedBean)parentElement, methodNames[i]);
				}
				return methods;
			}
			return new Object[0];
		}

		public Object getParent(Object element) {
			if(element instanceof ManagedBeanMethod){
				return ((ManagedBeanMethod)element).getParent();
			}
			return null;
		}

		public boolean hasChildren(Object element) {
			return getChildren(element).length > 0;
		}

		public Object[] getElements(Object inputElement) {
			return (ManagedBean[])inputElement;
		}

		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

	}

	private class ValueLabelProvider extends LabelProvider {

		public Image getImage(Object element) {
			if(element instanceof ManagedBean){
				return JSFPlugin.getDefault().getImage(JSFPlugin.ICON_CLASS);
			} else if(element instanceof ManagedBeanMethod){
				return JSFPlugin.getDefault().getImage(JSFPlugin.ICON_METHOD);
			}
			return super.getImage(element);
		}

		public String getText(Object element) {
			if(element instanceof ManagedBean){
				return ((ManagedBean)element).getBeanName() + " - " + 
				((ManagedBean)element).getClassName();
			} else if(element instanceof ManagedBeanMethod){
				return ((ManagedBeanMethod)element).getMethodName();
			}
			return super.getText(element);
		}

	}


}
