package tk.eclipse.plugin.visualjsf.descriptors;

import tk.eclipse.plugin.jsf.ManagedBean;

/**
 * The model class for the managed-bean method.
 * 
 * @author Naoki Takezoe
 */
public class ManagedBeanMethod {
	
	private ManagedBean parent;
	private String methodName;
	
	public ManagedBeanMethod(ManagedBean parent, String methodName){
		this.parent = parent;
		this.methodName = methodName;
	}
	
	public ManagedBean getParent(){
		return this.parent;
	}
	
	public String getMethodName(){
		return this.methodName;
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ManagedBeanMethod){
			ManagedBeanMethod method = (ManagedBeanMethod)obj;
			if(method.getParent().equals(this.parent) &&
					method.getMethodName().equals(this.methodName)){
				return true;
			}
		}
		return false;
	}
}
