package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.ComboBox;
import tk.eclipse.plugin.visualjsf.models.SelectOneMenuModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.SelectOneMenuModel}.
 * 
 * @author Naoki Takezoe
 */
public class SelectOneMenuEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		ComboBox combobox = new ComboBox();
		return combobox;
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		ComboBox combobox = new ComboBox();
		combobox.repaint();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		SelectOneMenuModel model = (SelectOneMenuModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("selectOneMenu_valueChangeListener", 
						model.getName())
		};
	}
}
