package tk.eclipse.plugin.visualjsf.figures;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.swt.graphics.Image;

/**
 * 
 * @author Naoki Takezoe
 */
public class CheckBox extends Label {
	
	private boolean checked = false;
	
	static final Image
		UNCHECKED = createImage("check_unchecked.gif"), //$NON-NLS-1$
		CHECKED = createImage("check_checked.gif"); //$NON-NLS-1$

	private static Image createImage(String name) {
		InputStream stream = RadioButton.class.getResourceAsStream(name);
		Image image = new Image(null, stream);
		try {
			stream.close();
		} catch (IOException ioe) {
		}
		return image;
	}

	public CheckBox() {
		this(""); //$NON-NLS-1$
	}

	public CheckBox(String text) {
		super(text, UNCHECKED);
		setTextPlacement(PositionConstants.EAST);
		setLabelAlignment(Label.LEFT);
	}
	
	public void setChecked(boolean checked){
		this.checked = checked;
		setIcon(checked ? CHECKED : UNCHECKED);
	}
	
	public boolean isChecked(){
		return this.checked;
	}
	
}
