package tk.eclipse.plugin.visualjsf.figures;

import org.eclipse.draw2d.ArrowButton;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;

/**
 * This figure represents a combo box control.
 * 
 * @author Takahiro Shida
 */
public class ComboBox extends Figure implements ColorConstants {

	private ArrowButton button = new ArrowButton(PositionConstants.SOUTH);
	private Label textBox = new Label();
	private static final Dimension MINIMUM = new Dimension(16, 16);

	public ComboBox() {
		super();
		CustomBorderLayout layout = new CustomBorderLayout();
		layout.setStretchCenterHeight(true);
		layout.setStretchCenterWidth(true);
		setLayoutManager(layout);
		setBorder(new SchemeBorder(new ButtonScheme(
				new Color[] { buttonDarkest, buttonDarker },
				new Color[] { buttonLightest, buttonDarker }
			)));

		textBox.setOpaque(true);
		textBox.setLabelAlignment(PositionConstants.LEFT);
		button.setSize(MINIMUM);
		button.setPreferredSize(MINIMUM);
		add(textBox, CustomBorderLayout.CENTER);
		add(button, CustomBorderLayout.RIGHT);
	}

	public void setText(String text) {
		this.textBox.setText(text);
	}
	
	public Label getTextBox() {
		return textBox;
	}
}
